/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.ClientUtilities;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;

public abstract class VersionDialog {
    protected DesktopComponentDialog dialog;
    protected JTextField majorField;
    protected JTextField minorField;
    protected JTextField patchField;
    protected AlgorithmInfo algoInfo;
    protected String dialogTitle;

    protected VersionDialog(AlgorithmInfo algoInfo) {
        this.algoInfo = algoInfo;
    }

    protected int[] getVersionNumbers() {
        int major = this.validateVersionNumberField(this.majorField, LNG.get((String)"algomanager.error.version_part"));
        if (major == -1) {
            return null;
        }
        int minor = this.validateVersionNumberField(this.minorField, LNG.get((String)"algomanager.error.version_part"));
        if (minor == -1) {
            return null;
        }
        int patch = this.validateVersionNumberField(this.patchField, LNG.get((String)"algomanager.error.version_part"));
        if (patch == -1) {
            return null;
        }
        Object id = AlgorithmVersionInfo.getIdFor((int)major, (int)minor, (int)patch);
        if (this.algoInfo.getVersionInfo(id) != null) {
            ClientUtilities.showErrorByTextField(this.dialog, LNG.get((String)"algomanager.error.dup_version"), null, this.majorField);
            return null;
        }
        return new int[]{major, minor, patch};
    }

    private int validateVersionNumberField(JTextField field, String errMsg) {
        try {
            int value = Integer.parseInt(field.getText());
            if (value >= 0 && value <= 999) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ClientUtilities.showErrorByTextField(this.dialog, errMsg, null, field);
        return -1;
    }
}

