/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.executor;

import csbase.client.algorithms.AlgorithmChooserEvent;
import csbase.client.algorithms.AlgorithmChooserListener;
import csbase.client.algorithms.AlgorithmChooserPanel;
import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTreePath;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.sga.CommandExecutionDialog;
import csbase.client.util.sga.CommandRequestedListener;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.serializer.AlgorithmConfigurationSerializerFactory;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerParameterNotFoundException;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.MenuButton;
import tecgraf.javautils.gui.StandardDialogs;

public final class ExecutorFrame
extends ApplicationProject {
    private AlgorithmChooserPanel algorithmChooserPanel;
    private AlgorithmConfiguratorView algorithmConfiguratorView;
    private AlgorithmConfigurator algorithmConfigurator;
    private SortedSet<AlgorithmInfo> algorithms = new TreeSet<AlgorithmInfo>();
    private boolean mustLoadAlgorithms;
    private JPanel buttonPanel;
    private JButton executeButton;
    private JButton paramButton;
    private JButton closeButton;
    private final List<CommandRequestedListener> listeners;
    private boolean mustShowCommandRequested;

    public ExecutorFrame(String id) {
        super(id);
        this.buildFrame();
        this.listeners = new LinkedList<CommandRequestedListener>();
        this.mustShowCommandRequested = true;
        this.mustLoadAlgorithms = true;
    }

    @Override
    public void killApplication() {
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (name == null) {
            throw new IllegalArgumentException("O par\u00e2metro name n\u00e3o pode ser nulo.");
        }
        if (value == null) {
            throw new IllegalArgumentException("O par\u00e2metro value n\u00e3o pode ser nulo.");
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile clientProjectFile = (ClientProjectFile)value;
            if (clientProjectFile.getType().equals("PARAMETERS")) {
                AlgorithmConfigurator configurator = this.readParameterFile(clientProjectFile);
                if (configurator == null) {
                    return;
                }
                String algorithmName = configurator.getAlgorithmName();
                AlgorithmVersionId versionId = configurator.getAlgorithmVersionId();
                if (algorithmName != null && versionId != null) {
                    if (!this.createConfigurator(algorithmName, versionId)) {
                        this.closeApplication();
                        return;
                    }
                } else {
                    String message = MessageFormat.format(this.getString("error.missing_information"), FileUtils.joinPath((char)'/', (String[])clientProjectFile.getPath()));
                    this.showError(message);
                    this.closeApplication();
                    return;
                }
                this.algorithmConfiguratorView.setCurrentPath(new ProjectTreePath(clientProjectFile));
                this.algorithmConfiguratorView.launch();
                return;
            }
            String path = FileUtils.joinPath((char)'/', (String[])clientProjectFile.getPath());
            String type = clientProjectFile.getType();
            FileURLValue inputFile = new FileURLValue(path, type);
            this.algorithmConfigurator.setDefaultInputFile(inputFile);
            return;
        }
    }

    public void showConfigurator(String algorithmName, AlgorithmVersionId algorithmVersionId, Map<String, String> algorithmParameters) throws ApplicationException {
        try {
            if (this.algorithmChooserPanel.selectAlgorithm(algorithmName) && this.algorithmChooserPanel.selectVersion(algorithmVersionId)) {
                if (algorithmParameters != null) {
                    this.algorithmConfigurator.setParameterValuesByName(algorithmParameters);
                }
                if (this.algorithmConfigurator != null) {
                    this.algorithmConfiguratorView.launch();
                }
            }
        }
        catch (ParseException e) {
            throw new ApplicationException(e);
        }
        catch (ParameterNotFoundException e) {
            throw new ApplicationException(e);
        }
    }

    public void showConfigurator(String algorithmName, Map<String, String> algorithmParameters) throws ApplicationException {
        if (this.algorithmChooserPanel.selectAlgorithm(algorithmName)) {
            AlgorithmInfo info = this.algorithmChooserPanel.getSelectedAlgorithmInfo();
            AlgorithmVersionId algorithmVersionId = info.getLastVersion().getId();
            this.showConfigurator(algorithmName, algorithmVersionId, algorithmParameters);
        }
    }

    @Override
    public void startApplication() throws ApplicationException {
        if (this.algorithmChooserPanel != null) {
            this.algorithmChooserPanel.setAlgorithmSet(this.getAlgorithmInfoSet());
            if (!this.algorithmChooserPanel.hasAlgorithms() && this.mustLoadAlgorithms) {
                DesktopComponentFrame window = DesktopFrame.getInstance().getDesktopFrame();
                StandardDialogs.showWarningDialog((Component)window, (String)this.getString("application.title"), (String)this.getString("error.no_algorithms"));
                return;
            }
        }
        super.startApplication();
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    private void buildFrame() {
        this.createAlgorithmChooserPanel();
        this.createButtonsPanel();
        this.populateFrame();
    }

    private void populateFrame() {
        Container cp = this.getApplicationFrame().getContentPane();
        cp.removeAll();
        cp.add((Component)this.algorithmChooserPanel, "Center");
        cp.add((Component)this.buttonPanel, "South");
        cp.validate();
        this.getApplicationFrame().pack();
    }

    private void clearConfigurator() {
        this.algorithmConfigurator = null;
        this.algorithmConfiguratorView = null;
    }

    private void createAlgorithmChooserPanel() {
        this.algorithmChooserPanel = new AlgorithmChooserPanel(this.getApplicationFrame(), this.mustShowHistory());
        this.algorithmChooserPanel.addAlgorithmChooserListener(new AlgorithmChooserListener(){

            @Override
            public void wasChangedVersion(AlgorithmChooserEvent event) {
                ExecutorFrame.this.updateVersionInfo();
                ExecutorFrame.this.updateButtons();
            }

            @Override
            public void wasChangedAlgorithm(AlgorithmChooserEvent event) {
                ExecutorFrame.this.clearConfigurator();
                ExecutorFrame.this.updateButtons();
            }
        });
        BorderUtil.setEtchedBorder((JComponent)this.algorithmChooserPanel, null);
    }

    private void createButtonsPanel() {
        this.closeButton = new JButton(this.getString("button.close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExecutorFrame.this.closeApplication();
            }
        });
        this.executeButton = new JButton(this.getString("button.execute"));
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExecutorFrame.this.showExecuteDialog();
            }
        });
        this.paramButton = new JButton(this.getString("button.parameter"));
        this.paramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExecutorFrame.this.showParamsDialog();
            }
        });
        MenuButton extrasMenu = new MenuButton((Icon)ApplicationImages.ICON_BLANK_16, MenuButton.PopupPosition.BOTTOM);
        List<JMenuItem> extraMenuItems = this.getExtraOperations();
        for (JMenuItem extraMenuItem : extraMenuItems) {
            extrasMenu.add(extraMenuItem);
        }
        extrasMenu.setVisible(!extraMenuItems.isEmpty());
        ClientUtilities.adjustEqualSizes(this.paramButton, this.closeButton, this.executeButton);
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.paramButton);
        this.buttonPanel.add(this.executeButton);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add((Component)extrasMenu);
        this.updateButtons();
    }

    private List<JMenuItem> getExtraOperations() {
        ArrayList<JMenuItem> ops = new ArrayList<JMenuItem>();
        if (this.getBooleanSpecificProperty("flow.extra.operation", true)) {
            String openInFlowText = this.getString("button.flowapp");
            JMenuItem openInFlowAppItem = new JMenuItem(openInFlowText, ApplicationImages.ICON_FLOW_16);
            openInFlowAppItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ExecutorFrame.this.openInFlowApplication();
                }
            });
            ops.add(openInFlowAppItem);
        }
        return ops;
    }

    private void openInFlowApplication() {
        if (this.algorithmConfigurator != null) {
            try {
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                FlowApplication flowApp = applicationManager.runApplication(FlowApplication.class);
                flowApp.sendMessage("CONFIGURATOR_MESSAGE", this.algorithmConfigurator, this.getInstanceId());
            }
            catch (ApplicationException e) {
                this.showError(this.getString("error.flowapp_not_available"));
            }
        }
    }

    private boolean createConfigurator(String algorithmName, AlgorithmVersionId versionId) {
        if (!this.algorithmChooserPanel.selectAlgorithm(algorithmName)) {
            this.showError(MessageFormat.format(this.getString("error.algorithm_not_found"), algorithmName));
            return false;
        }
        if (!this.algorithmChooserPanel.selectVersion(versionId)) {
            this.showError(MessageFormat.format(this.getString("error.version_not_found"), algorithmName, versionId));
            return false;
        }
        return true;
    }

    private boolean mustShowHistory() {
        return this.getBooleanSpecificProperty("showHistory", true);
    }

    private AlgorithmConfigurator readParameterFile(final ClientProjectFile clientProjectFile) {
        RemoteTask<AlgorithmConfigurator> task = new RemoteTask<AlgorithmConfigurator>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                try (InputStream inputStream = null;){
                    inputStream = clientProjectFile.getInputStream();
                    IAlgorithmConfigurationSerializer serializer = AlgorithmConfigurationSerializerFactory.getSerializer(AlgorithmConfigurator.class);
                    AlgorithmConfigurator configurator = serializer.read(inputStream);
                    this.setResult(configurator);
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof ParseException) {
                    ExecutorFrame.this.showError(error.getLocalizedMessage());
                } else if (error instanceof AlgorithmConfigurationSerializerParameterNotFoundException) {
                    ExecutorFrame.this.showError(error.getLocalizedMessage());
                } else {
                    super.handleError(error);
                }
            }
        };
        if (task.execute(this.getApplicationFrame(), this.getName(), this.getString("msg.reading.file"))) {
            return (AlgorithmConfigurator)task.getResult();
        }
        return null;
    }

    private void setConfiguratorView(AlgorithmConfiguratorView configuratorView) {
        this.algorithmConfiguratorView = configuratorView;
        this.algorithmConfigurator = configuratorView.getConfigurator();
    }

    private void showParamsDialog() {
        this.algorithmConfiguratorView.launch();
    }

    private void showExecuteDialog() {
        CommandExecutionDialog commandExecutionDialog = new CommandExecutionDialog(this.getApplicationFrame(), this.algorithmConfiguratorView.getConfigurator(), this.getApplicationProject());
        commandExecutionDialog.addCommandRequestedListener(new CommandRequestedListener(){

            @Override
            public void commandsWereRequested(Set<CommandInfo> submittedCommands) {
                if (!ExecutorFrame.this.mustShowCommandRequested) {
                    return;
                }
                int numberOfSubmittedCommands = submittedCommands.size();
                if (numberOfSubmittedCommands == 1) {
                    CommandInfo command = submittedCommands.iterator().next();
                    if (command.isAutomatic()) {
                        ExecutorFrame.this.showCommandRequest(MessageFormat.format(ExecutorFrame.this.getString("msg.command_auto_requested"), command.getTip()));
                    } else {
                        ExecutorFrame.this.showCommandRequest(MessageFormat.format(ExecutorFrame.this.getString("msg.command_requested_on_server"), command.getTip(), command.getSGAName()));
                    }
                } else {
                    CommandInfo firstCommand = submittedCommands.iterator().next();
                    if (firstCommand.isAutomatic()) {
                        ExecutorFrame.this.showCommandRequest(MessageFormat.format(ExecutorFrame.this.getString("msg.command_auto_requested_on_servers"), firstCommand.getTip(), numberOfSubmittedCommands));
                    } else {
                        String requestedServers = "";
                        HashSet<String> sgaNames = new HashSet<String>();
                        for (CommandInfo command : submittedCommands) {
                            if (!sgaNames.add(command.getSGAName())) continue;
                            requestedServers = requestedServers + "\n - " + command.getSGAName();
                        }
                        int nExecutions = firstCommand.getExecutionCountPerSGAForMultipleExecution();
                        ExecutorFrame.this.showCommandRequest(MessageFormat.format(ExecutorFrame.this.getString("msg.command_requested_on_servers"), firstCommand.getTip(), requestedServers, nExecutions));
                    }
                }
            }
        });
        this.addExternalListeners(commandExecutionDialog);
        commandExecutionDialog.setVisible(true);
    }

    private void showCommandRequest(String message) {
        JScrollPane scrollPane;
        int option;
        if (message == null) {
            throw new IllegalArgumentException("O par\u00e2metro message est\u00e1 nulo.");
        }
        Object[] buttons = new String[]{this.getString("button.monitor"), this.getString("button.close")};
        ApplicationFrame applicationFrame = this.getApplicationFrame();
        String applicationTitle = applicationFrame.getTitle();
        JTextArea area = new JTextArea(message);
        area.setEditable(false);
        int min_rows = 3;
        int max_rows = 10;
        String[] s = message.split("\\n", 10);
        if (s.length > 3) {
            area.setRows(10);
        }
        if ((option = JOptionPane.showOptionDialog(applicationFrame, scrollPane = new JScrollPane(area), applicationTitle, -1, 1, null, buttons, buttons[1])) == 0) {
            try {
                ApplicationManager.getInstance().runApplication("commandsmonitor");
            }
            catch (ApplicationException ex) {
                this.showException(ex.getMessage(), ex);
            }
        }
    }

    private void addExternalListeners(CommandExecutionDialog commandExecutionDialog) {
        for (CommandRequestedListener listener : this.listeners) {
            commandExecutionDialog.addCommandRequestedListener(listener);
        }
    }

    public void addCommandRequestedListener(CommandRequestedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    private void updateButtons() {
        boolean enableButton = true;
        if (this.algorithmConfigurator == null) {
            enableButton = false;
            this.getApplicationFrame().getStatusBar().setError(this.getString("status.error.null_configurator"));
        } else if (this.algorithmConfigurator.hasParameterThatRequiresPipe()) {
            enableButton = false;
            this.getApplicationFrame().getStatusBar().setError(this.getString("status.error.flow_only_algorithm"));
        } else {
            this.getApplicationFrame().getStatusBar().setStatus(null);
        }
        this.executeButton.setEnabled(enableButton);
        this.paramButton.setEnabled(enableButton);
    }

    private void updateChooserPanel() {
        this.algorithmChooserPanel.setDescription(this.algorithmConfigurator.getDescription());
    }

    private SortedSet<AlgorithmInfo> getAlgorithmInfoSet() {
        block2: {
            ApplicationFrame frame;
            block3: {
                this.algorithms = new TreeSet<AlgorithmInfo>();
                List<String> algoIds = this.getStringListSpecificProperty("algo.id");
                if (!this.mustLoadAlgorithms) break block2;
                frame = this.getApplicationFrame();
                if (algoIds.size() <= 0) break block3;
                for (String algoId : algoIds) {
                    AlgorithmInfo info = AlgorithmManagementProxy.getAlgorithmInfoById(algoId, frame, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
                    if (info == null) continue;
                    this.algorithms.add(info);
                }
                break block2;
            }
            AlgorithmInfo[] infos = AlgorithmManagementProxy.getAllAlgorithmInfos(frame, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
            if (infos == null) break block2;
            for (AlgorithmInfo info : infos) {
                String hideProp = "ocultar";
                if (info.getPropertyValue("ocultar") != null) continue;
                this.algorithms.add(info);
            }
        }
        return this.algorithms;
    }

    private void updateVersionInfo() {
        AlgorithmVersionInfo selectedVersionInfo = this.algorithmChooserPanel.getSelectedVersionInfo();
        this.clearConfigurator();
        if (selectedVersionInfo != null) {
            AlgorithmConfiguratorView configuratorView = AlgorithmConfiguratorFactory.getInstance().createConfigurationView(this.getApplicationFrame(), selectedVersionInfo, ValidationMode.FULL);
            if (configuratorView == null) {
                return;
            }
            this.setConfiguratorView(configuratorView);
            this.updateChooserPanel();
        }
        this.getApplicationFrame().pack();
    }

    private AlgorithmInfo getAlgorithmInfo(String algorithmName) throws ApplicationException {
        AlgorithmInfo info = AlgorithmManagementProxy.getAlgorithmInfoByName(algorithmName, this.getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        if (info == null) {
            throw new ApplicationException(this.getString("error.inexistent_algorithm"));
        }
        return info;
    }

    private SortedSet<AlgorithmVersionInfo> getAlgorithmVersionSet(AlgorithmInfo algorithmInfo, AlgorithmVersionId[] versionIdList) {
        TreeSet<AlgorithmVersionInfo> sortedVersionSet = new TreeSet<AlgorithmVersionInfo>();
        for (AlgorithmVersionId versionId : versionIdList) {
            AlgorithmVersionInfo versionInfo = algorithmInfo.getVersionInfo((Object)versionId);
            if (versionInfo == null) continue;
            sortedVersionSet.add(versionInfo);
        }
        return sortedVersionSet;
    }

    public void setSingleAlgorithm(String algorithmName, AlgorithmVersionId[] versionIdList) throws ApplicationException {
        AlgorithmInfo algorithmInfo = this.getAlgorithmInfo(algorithmName);
        this.algorithms.add(algorithmInfo);
        this.algorithmChooserPanel.setAlgorithmSet(this.algorithms);
        if (versionIdList != null) {
            SortedSet<AlgorithmVersionInfo> algorithmVersionSet = this.getAlgorithmVersionSet(algorithmInfo, versionIdList);
            this.algorithmChooserPanel.setAlgorithmVersion(algorithmVersionSet);
        }
    }

    public void setSingleAlgorithm(String algorithmName) throws ApplicationException {
        this.setSingleAlgorithm(algorithmName, null);
    }

    public boolean isMustShowCommandRequested() {
        return this.mustShowCommandRequested;
    }

    public void showCommandRequestedInfo(boolean state) {
        this.mustShowCommandRequested = state;
    }

    public void enableLoadAlgorithms(boolean state) {
        this.mustLoadAlgorithms = state;
    }

    public void setCommandDescription(String commandDescription) {
        this.algorithmConfigurator.setCommandDescription(commandDescription);
    }
}

