/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.localpanel;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.actions.ChangeLocalDirectoryAction;
import csbase.client.applications.filetransferclient.actions.HomeLocalAction;
import csbase.client.applications.filetransferclient.actions.RefreshLocalAction;
import csbase.client.applications.filetransferclient.actions.UpLocalDirectoryAction;
import csbase.client.applications.filetransferclient.panels.core.FileTransferClientPanel;
import csbase.client.applications.filetransferclient.panels.localpanel.LocalTableModel;
import csbase.client.applications.filetransferclient.panels.localpanel.LocalTableRenderer;
import csbase.client.applications.filetransferclient.panels.localpanel.LocalTypeComparator;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SortOrder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.table.SortableTable;

public class FileTransferClientLocalPanel
extends FileTransferClientPanel {
    private ClientProjectFile localDirectory;
    private SortableTable localTable = new SortableTable();
    private JTextField localDirText = new JTextField();
    private final JTextField projectText = new JTextField(30);
    private final JTextField userText = new JTextField(30);
    private boolean dotFiltered = true;

    public boolean isDotFiltered() {
        return this.dotFiltered;
    }

    public void setDotFiltered(boolean dotFiltered) {
        this.dotFiltered = dotFiltered;
        this.refresh();
    }

    public final List<ClientProjectFile> getSelectedFiles() {
        int[] sels = this.localTable.getSelectedRows();
        if (sels == null || sels.length == 0) {
            return null;
        }
        LocalTableModel model = (LocalTableModel)this.localTable.getModel();
        ArrayList<ClientProjectFile> modelList = model.getFileList();
        ArrayList<ClientProjectFile> files = new ArrayList<ClientProjectFile>();
        for (int sel : sels) {
            int modelSel = this.localTable.convertRowIndexToModel(sel);
            ClientProjectFile file = modelList.get(modelSel);
            files.add(file);
        }
        Collections.unmodifiableList(files);
        return files;
    }

    private void doubleClickedOnTable() {
        List<ClientProjectFile> sels = this.getSelectedFiles();
        if (sels.size() != 1) {
            return;
        }
        ClientProjectFile selected = sels.get(0);
        if (selected == null) {
            return;
        }
        String fileName = selected.getName();
        if (selected.isDirectory()) {
            ClientProjectFile localDir = this.getLocalDirectory();
            ClientProjectFile newLocalDir = GetChildFromNameTask.runTask(localDir, fileName);
            this.setLocalDirectory(newLocalDir);
        } else {
            this.refresh();
            FileTransferClient application = this.getApplication();
            FileTransferClientQueuePanel queuePanel = application.getQueuePanel();
            queuePanel.refresh();
        }
    }

    private void mountPanel(String serverName) {
        this.setLayout(new BorderLayout());
        JPanel infoPanel = this.buildInfoPanel(serverName);
        JToolBar toolBar = this.buildToolBar();
        String[] cNames = new String[]{this.getString("fd.column"), this.getString("name.column"), this.getString("size.column")};
        LocalTableModel model = new LocalTableModel(cNames);
        this.localTable.setModel((TableModel)model);
        this.localTable.setComparator(0, (Comparator)new LocalTypeComparator());
        this.localTable.setNoSortStateEnabled(true);
        this.localTable.setSelectionMode(2);
        this.localTable.sort(0, SortOrder.ASCENDING);
        LocalTableRenderer renderer = new LocalTableRenderer();
        this.localTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)renderer);
        this.localTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this.localTable.setDefaultRenderer(Long.class, (TableCellRenderer)renderer);
        this.localTable.setDefaultRenderer(ClientProjectFile.class, (TableCellRenderer)renderer);
        this.localTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileTransferClientLocalPanel.this.doubleClickedOnTable();
                }
            }
        });
        TableColumnModel colModel = this.localTable.getColumnModel();
        this.localTable.setAutoResizeMode(3);
        TableColumn c0 = colModel.getColumn(0);
        TableColumn c1 = colModel.getColumn(1);
        TableColumn c2 = colModel.getColumn(2);
        c0.setPreferredWidth(10);
        c1.setPreferredWidth(150);
        c2.setPreferredWidth(40);
        JScrollPane scrollTable = new JScrollPane((Component)this.localTable);
        this.add((Component)infoPanel, "North");
        this.add((Component)scrollTable, "Center");
        this.add((Component)toolBar, "South");
        FileTransferClientUI.setEtchedBorder(this);
    }

    private JToolBar buildToolBar() {
        FileTransferClient ftpClient = this.getApplication();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(new HomeLocalAction(ftpClient));
        toolBar.addSeparator();
        toolBar.add(new ChangeLocalDirectoryAction(ftpClient));
        toolBar.add(new UpLocalDirectoryAction(ftpClient));
        toolBar.add(new JPanel());
        toolBar.add(new RefreshLocalAction(ftpClient));
        return toolBar;
    }

    private JPanel buildInfoPanel(String serverName) {
        this.localDirText.setEditable(false);
        this.userText.setEditable(false);
        this.projectText.setEditable(false);
        JLabel localDirLabel = new JLabel();
        localDirLabel.setText(this.getString("local.directory.label"));
        JLabel userLabel = new JLabel();
        userLabel.setText(this.getString("local.user.label"));
        User user = User.getLoggedUser();
        this.userText.setText(user.getLogin());
        JLabel projectLabel = new JLabel();
        projectLabel.setText(this.getString("local.project.label"));
        CommonClientProject project = this.getApplication().getApplicationProject();
        this.projectText.setText(project.getName());
        JPanel infoPanel = new JPanel();
        JComponent[][] cmps = new JComponent[][]{{userLabel, this.userText}, {projectLabel, this.projectText}, {localDirLabel, this.localDirText}};
        GUIUtils.mountBasicGridPanel((JPanel)infoPanel, (JComponent[][])cmps);
        JLabel serverLabel = new JLabel();
        DesktopFrame desktop = DesktopFrame.getInstance();
        Image desktopImage = desktop.getFrameImage();
        if (desktopImage != null) {
            ImageIcon icon = new ImageIcon(desktopImage);
            serverLabel.setIcon(icon);
            serverLabel.setText(serverName);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)serverLabel, new GBC(0, 0).none().west().insets(0, 0, 20, 0));
        panel.add((Component)infoPanel, new GBC(0, 1).both());
        return panel;
    }

    public final ClientProjectFile getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(ClientProjectFile localDirectory) {
        if (localDirectory == null) {
            DesktopFrame mainFrame = DesktopFrame.getInstance();
            CommonClientProject project = mainFrame.getProject();
            this.localDirectory = project.getRoot();
        } else {
            this.localDirectory = localDirectory;
        }
        String text = FileTransferClientUI.pathToString(this.localDirectory);
        if (FileTransferClientUI.isEmptyString(text)) {
            this.localDirText.setText("/");
        } else {
            this.localDirText.setText(text);
        }
        this.refresh();
    }

    public final void refresh() {
        LocalTableModel model = (LocalTableModel)this.localTable.getModel();
        ArrayList<ClientProjectFile> list = new ArrayList<ClientProjectFile>();
        try {
            ClientProjectFile[] children;
            if (this.localDirectory == null) {
                return;
            }
            for (ClientProjectFile file : children = this.localDirectory.getChildren()) {
                if (!this.filterAllows(file)) continue;
                list.add(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.setFileList(list);
    }

    private boolean filterAllows(ClientProjectFile file) {
        String name = file.getName();
        return !this.dotFiltered || !name.startsWith(".");
    }

    public FileTransferClientLocalPanel(FileTransferClient application, String serverName) {
        super(application);
        this.mountPanel(serverName);
        this.setLocalDirectory(null);
        this.addProjectTreeListener();
    }

    private void addProjectTreeListener() {
        ProjectTree tree = DesktopFrame.getInstance().getTree();
        tree.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                FileTransferClientLocalPanel.this.refresh();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                FileTransferClientLocalPanel.this.refresh();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                FileTransferClientLocalPanel.this.refresh();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                FileTransferClientLocalPanel.this.refresh();
            }
        });
    }
}

