/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;

public class EnableLabelAction
extends FlowApplicationAction {
    public EnableLabelAction(FlowApplication application) {
        super(application, FlowApplicationUI.LABEL_ICON);
        this.setEnabled(false);
    }

    @Override
    public void handleActionPerformed(ActionEvent e) {
        AbstractButton aButton = (AbstractButton)e.getSource();
        boolean selected = aButton.getModel().isSelected();
        ((FlowApplication)this.getApplication()).setLabelEnabled(selected);
    }

    @Override
    public void wasElementCreated(Graph graph, GraphElement element) {
        this.updateEnabled(graph);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.updateEnabled(graph);
    }

    @Override
    public void wasElementSelected(Graph graph, GraphElement element) {
        this.updateEnabled(graph);
    }

    @Override
    public void wasChangedWorkspace(Graph graph) {
        this.updateEnabled(graph);
    }

    @Override
    public void wasReseted(Graph graph) {
        this.updateEnabled(graph);
    }

    private void updateEnabled(Graph graph) {
        if (!graph.getNodeCollection().isEmpty()) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

