/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.logic.ProjectSynchronizationFileInfo;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.CardLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class ContainerSelectionFiles {
    private JPanel rootPanel;
    private JPanel projectsPanel;
    private ContainerSelection<ProjectSynchronizationFileInfo> containerSelection;
    private ApplicationRegistry registry;

    ContainerSelectionFiles(ApplicationRegistry registry) {
        this.registry = registry;
    }

    public JPanel getRootPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            CardLayout cardLayout = new CardLayout();
            cardLayout.setHgap(3);
            cardLayout.setVgap(3);
            this.rootPanel.setLayout(cardLayout);
            this.rootPanel.add("projectsPanel", this.getProjectsPanel());
        }
        return this.rootPanel;
    }

    private JPanel getProjectsPanel() {
        if (this.projectsPanel == null) {
            this.projectsPanel = new JPanel(new GridLayout(1, 1));
            this.projectsPanel.add(this.getContainerSelection().getPanel());
        }
        return this.projectsPanel;
    }

    public ContainerSelection<ProjectSynchronizationFileInfo> getContainerSelection() {
        if (this.containerSelection == null) {
            String origem = this.registry.getString("files");
            String destino = this.registry.getString("selectedFiles");
            this.containerSelection = new ContainerSelection((ObjectTableProvider)new TableProvider(), (ObjectTableProvider)new TableProvider(), true, true, origem, destino);
            this.containerSelection.adjustTableColumns();
        }
        return this.containerSelection;
    }

    public class TableProvider
    extends DefaultObjectTableProvider {
        public String[] getColumnNames() {
            return new String[]{ContainerSelectionFiles.this.registry.getString("file"), ContainerSelectionFiles.this.registry.getString("new")};
        }

        public Class<?>[] getColumnClasses() {
            return new Class[]{String.class, String.class};
        }

        public Object[] getCellValues(Object arg) {
            ProjectSynchronizationFileInfo psfi = (ProjectSynchronizationFileInfo)arg;
            String str = psfi.isNewFile() ? ContainerSelectionFiles.this.registry.getString("yes") : ContainerSelectionFiles.this.registry.getString("no");
            return new String[]{psfi.generateAbsoluteFilename(), str};
        }
    }
}

