/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.filesystem;

import csdk.v1_0.api.filesystem.IFileLock;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.Task;

public class CSDKLocalFileLock
implements IFileLock {
    private final FileLock lock;
    private FileChannel channel;

    public CSDKLocalFileLock(final File file, final boolean shared, final Window window) throws Exception {
        if (file.isDirectory()) {
            throw new Exception("A directory cannot be locked (" + file.getAbsolutePath() + ")");
        }
        Task<FileLock> task = new Task<FileLock>(){

            protected void performTask() {
                FileLock fileLock = CSDKLocalFileLock.this._lock(shared, window, file);
                this.setResult(fileLock);
            }
        };
        String prefix = CSDKLocalFileLock.class.getSimpleName();
        String key = shared ? ".shared.lock.message" : ".exclusive.lock.message";
        String message = LNG.get((String)(prefix + key));
        task.execute(window, null, message);
        this.lock = (FileLock)task.getResult();
        if (task.wasCancelled()) {
            this.releaseLock(window);
        }
    }

    public IFileLock.LockStatus getLockStatus() {
        if (this.lock != null) {
            if (this.lock.isValid()) {
                if (this.lock.isShared()) {
                    return IFileLock.LockStatus.LOCK_SHARED;
                }
                return IFileLock.LockStatus.LOCK_EXCLUSIVE;
            }
            return IFileLock.LockStatus.LOCK_RELEASED;
        }
        return IFileLock.LockStatus.LOCK_DENIED;
    }

    public void releaseLock(Window window) {
        Task<Void> task = new Task<Void>(){

            protected void performTask() throws Exception {
                try {
                    CSDKLocalFileLock.this._releaseLock(CSDKLocalFileLock.this.lock);
                }
                finally {
                    if (CSDKLocalFileLock.this.channel != null) {
                        CSDKLocalFileLock.this.channel.close();
                    }
                }
            }
        };
        String prefix = CSDKLocalFileLock.class.getSimpleName();
        String message = LNG.get((String)(prefix + ".release.lock.message"));
        task.execute(window, null, message);
    }

    private FileLock _lock(boolean shared, Window window, File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            String mode = shared ? "r" : "rws";
            randomAccessFile = new RandomAccessFile(file, mode);
            this.channel = randomAccessFile.getChannel();
            return this.channel.tryLock(0L, Long.MAX_VALUE, shared);
        }
        catch (Exception ex) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    private void _releaseLock(FileLock fileLock) throws IOException {
        if (fileLock != null && fileLock.isValid()) {
            fileLock.release();
        }
    }
}

