/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.types;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVColorEditor;
import csbase.client.preferences.util.PreferenceBundle;
import java.awt.Color;

public class PVColor
extends PreferenceValue<Color> {
    public PVColor(PreferenceDefinition name, String value, String defaultValue, PreferencePolicy policy, PreferenceBundle preferenceBundle) {
        super(name, value, defaultValue, policy, preferenceBundle);
        this.setPreferenceEditorClass(PVColorEditor.class);
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public Color toValue(String value) {
        if ("".equals(value)) {
            return Color.GRAY;
        }
        String[] values = value.split(" *, *");
        int r = Integer.parseInt(values[0].trim());
        int g = Integer.parseInt(values[1].trim());
        int b = Integer.parseInt(values[2].trim());
        return new Color(r, g, b);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Color)this.getValue()).getRed());
        builder.append(",");
        builder.append(((Color)this.getValue()).getGreen());
        builder.append(",");
        builder.append(((Color)this.getValue()).getBlue());
        return builder.toString();
    }

    @Override
    public PreferenceValue<Color> clone() {
        return new PVColor(this.name, this.toString(), this.defaultValue, this.policy, this.preferenceBundle);
    }
}

