/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.dialogs.ProjectBuildingDialog;
import csbase.client.project.dialogs.ProjectDataExtensionPanel;
import csbase.client.util.ClientUtilities;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

class ProjectCreationDialog
extends ProjectBuildingDialog {
    ProjectCreationDialog(Window owner, ProjectDataExtensionPanel extraPanel) {
        super(owner, extraPanel);
    }

    private void createProjectAction() {
        User loggedUser = User.getLoggedUser();
        Object ownerId = loggedUser.isAdmin() ? this.projectOwnerField.getText() : loggedUser.getId();
        String projectName = this.nameField.getText();
        if (!ClientUtilities.isValidFileName(projectName)) {
            StandardDialogs.showErrorDialog((Component)this, (String)this.getTitle(), (String)LNG.get((String)"ProjectCreationDialog.character.error.message"));
            return;
        }
        String description = this.descrField.getText();
        Hashtable<String, Object> panelDataTable = new Hashtable<String, Object>();
        if (this.extraPanel != null) {
            panelDataTable.putAll(this.extraPanel.getPanelData());
        }
        Window window = this.getOwner();
        if (this.lockingBox != null && this.lockingBox.isSelected()) {
            String stas = this.sizeField.getText();
            if (stas.trim().isEmpty()) {
                StandardDialogs.showErrorDialog((Component)window, (String)LNG.get((String)"ProjectCreationDialog.invalid.space.definition.title"), (String)LNG.get((String)"ProjectCreationDialog.invalid.space.definition.msg"));
                return;
            }
            int spaceToAllocate = Integer.parseInt(stas);
            if (!this.createProjectWithAreaReserved(window, projectName, description, String.valueOf(ownerId), panelDataTable, spaceToAllocate)) {
                return;
            }
        } else {
            this.project = this.createProject(window, projectName, description, String.valueOf(ownerId), panelDataTable);
            if (this.project == null) {
                return;
            }
        }
        this.dispose();
    }

    @Override
    protected void addActions() {
        super.addActions();
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectCreationDialog.this.createProjectAction();
            }
        };
        KeyStroke okKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.addActionToComponent(okAction, this.nameField, okKeyStroke, 0);
    }

    private CommonClientProject createProject(Window window, final String projectName, final String description, final String ownerId, final Hashtable<String, Object> extraData) {
        RemoteTask<CommonClientProject> task = new RemoteTask<CommonClientProject>(){

            public void performTask() throws Exception {
                ProjectServiceInterface psi = ClientRemoteLocator.projectService;
                CommonProjectInfo cpi = new CommonProjectInfo();
                cpi.name = projectName;
                cpi.userId = ownerId;
                cpi.description = description;
                if (extraData != null) {
                    cpi.getAttributes().putAll(extraData);
                }
                CommonClientProject prj = psi.createProject(cpi);
                this.setResult(prj);
            }
        };
        if (task.execute(window, this.getTitle(), LNG.get((String)"ProjectCreationDialog.waiting.create.title"))) {
            return (CommonClientProject)task.getResult();
        }
        return null;
    }

    @Override
    void setOkButton(JButton confirmButton) {
        confirmButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectCreationDialog.this.createProjectAction();
            }
        });
        confirmButton.setText(LNG.get((String)"ProjectCreationDialog.creation.button"));
    }

    private boolean createProjectWithAreaReserved(Window window, final String projectName, final String description, final String ownerId, final Hashtable<String, Object> extraData, final int spaceToAllocate) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                ProjectServiceInterface psi = ClientRemoteLocator.projectService;
                CommonProjectInfo cpi = new CommonProjectInfo();
                cpi.name = projectName;
                cpi.userId = ownerId;
                cpi.description = description;
                if (extraData != null) {
                    cpi.getAttributes().putAll(extraData);
                }
                psi.createProjectWithAllocation(cpi, (long)spaceToAllocate);
            }
        };
        if (task.execute(window, this.getTitle(), LNG.get((String)"ProjectCreationDialog.waiting.create.message"))) {
            String message = LNG.get((String)"ProjectCreationDialog.project.creation.withlock.message");
            StandardDialogs.showInfoDialog((Component)window, (String)this.getTitle(), (Object)MessageFormat.format(message, projectName));
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return LNG.get((String)"ProjectCreationDialog.creation.title");
    }
}

