/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class AnimatedIcon
implements Icon {
    private ImageIcon original;
    private final Set<RepaintArea> repaints = new HashSet<RepaintArea>();

    protected AnimatedIcon() {
    }

    public AnimatedIcon(ImageIcon original) {
        if (original == null) {
            throw new IllegalArgumentException("O par\u00e2metro original est\u00e1 nulo");
        }
        this.original = original;
        new AnimationObserver(this, original);
    }

    protected synchronized void repaint() {
        Iterator<RepaintArea> i = this.repaints.iterator();
        while (i.hasNext()) {
            i.next().repaint();
        }
        this.repaints.clear();
    }

    @Override
    public int getIconHeight() {
        return this.original.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.original.getIconWidth();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.original.paintIcon(c, g, x, y);
        if (c != null) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            AffineTransform tx = ((Graphics2D)g).getTransform();
            w = (int)((double)w * tx.getScaleX());
            h = (int)((double)h * tx.getScaleY());
            this.repaints.add(new RepaintArea(c, x, y, w, h));
        }
    }

    private static class AnimationObserver
    implements ImageObserver {
        private final WeakReference<AnimatedIcon> ref;
        private final ImageIcon original;

        public AnimationObserver(AnimatedIcon animIcon, ImageIcon original) {
            this.original = original;
            this.original.setImageObserver(this);
            this.ref = new WeakReference<AnimatedIcon>(animIcon);
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            if ((flags & 0x30) != 0) {
                AnimatedIcon animIcon = (AnimatedIcon)this.ref.get();
                if (animIcon != null) {
                    animIcon.repaint();
                } else {
                    this.original.setImageObserver(null);
                }
            }
            return (flags & 0xA0) == 0;
        }
    }

    private class RepaintArea {
        public int x;
        public int y;
        public int w;
        public int h;
        public Component component;
        private final int hashCode;

        public RepaintArea(Component c, int x, int y, int w, int h) {
            Component nc = c;
            int nx = x;
            int ny = y;
            Component ancestor = this.findNonRendererAncestor(nc);
            if (ancestor != nc) {
                Point pt = SwingUtilities.convertPoint(nc, nx, ny, ancestor);
                nc = ancestor;
                nx = pt.x;
                ny = pt.y;
            }
            this.component = nc;
            this.x = nx;
            this.y = ny;
            this.w = w;
            this.h = h;
            String hash = String.valueOf(nx) + "," + ny + ":" + nc.hashCode();
            this.hashCode = hash.hashCode();
        }

        private Component findNonRendererAncestor(Component c) {
            Component nc = c;
            Container ancestor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, nc);
            if (ancestor != null && ancestor != nc && ancestor.getParent() != null) {
                nc = this.findNonRendererAncestor(ancestor.getParent());
            }
            return nc;
        }

        public void repaint() {
            this.component.repaint(this.x, this.y, this.w, this.h);
        }

        public boolean equals(Object o) {
            if (o instanceof RepaintArea) {
                RepaintArea area = (RepaintArea)o;
                return area.component == this.component && area.x == this.x && area.y == this.y && area.w == this.w && area.h == this.h;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Repaint(" + this.component.getClass().getName() + "@" + this.x + "," + this.y + " " + this.w + "x" + this.h + ")";
        }
    }
}

