/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.filters.ClientFileAllFilter;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.client.util.filechooser.filters.ClientFileMultipleTypesFilter;
import csbase.client.util.filechooser.filters.ClientFileSingleTypeFilter;
import csbase.logic.ClientFile;
import csbase.logic.ClientSGAFile;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClientSGAFileChooserUtil {
    public static ClientSGAFile browseSingleFileInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.browseSingleInOpenMode(window, title, fileTypes, currentDirectory, allowAll, ClientFileChooserSelectionMode.FILES_ONLY);
    }

    public static ClientSGAFile browseSingleDirectoryInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.browseSingleInOpenMode(window, title, fileTypes, currentDirectory, allowAll, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
    }

    public static List<ClientSGAFile> browseMultipleFilesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.browseMultipleInOpenMode(window, title, fileTypes, allowAll, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
    }

    public static List<ClientSGAFile> browseMultipleDirectoriesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.browseMultipleInOpenMode(window, title, fileTypes, allowAll, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
    }

    public static ClientSGAFile browseSingleFileInSaveMode(Window window, Collection<String> fileTypes, String defaultFileType, String title, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.browseSingleInSaveMode(window, title, fileTypes, defaultFileType, allowAll, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
    }

    public static ClientSGAFile browseSingleDirectoryInSaveMode(Window window, Collection<String> fileTypes, String defaultFileType, String title, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.browseSingleInSaveMode(window, title, fileTypes, defaultFileType, allowAll, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
    }

    private static ClientSGAFile browseSingleInOpenMode(Window window, String title, Collection<String> fileTypes, ClientSGAFile currentDirectory, boolean allowAll, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setCurrentDirectory((ClientFile)currentDirectory);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.OPEN);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileTypes != null) {
            if (fileTypes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileTypes));
            }
            for (String fileType : fileTypes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileType);
                filters.add(flt);
            }
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (!filters.isEmpty()) {
            chooser.setSelectedFilter((ClientFileFilterInterface)filters.get(0));
        }
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null || selected.size() == 0) {
            return null;
        }
        ClientSGAFile first = (ClientSGAFile)selected.get(0);
        return first;
    }

    private static List<ClientSGAFile> browseMultipleInOpenMode(Window window, String title, Collection<String> fileTypes, boolean allowAll, ClientSGAFile currentDirectory, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setCurrentDirectory((ClientFile)currentDirectory);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.OPEN);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.MULTIPLE_CHOOSE);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileTypes != null) {
            if (fileTypes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileTypes));
            }
            for (String fileType : fileTypes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileType);
                filters.add(flt);
            }
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (!filters.isEmpty()) {
            chooser.setSelectedFilter((ClientFileFilterInterface)filters.get(0));
        }
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null) {
            return null;
        }
        ArrayList<ClientSGAFile> sgaFileSelected = new ArrayList<ClientSGAFile>();
        for (ClientFile clientFile : selected) {
            ClientSGAFile clientLocalFile = (ClientSGAFile)clientFile;
            sgaFileSelected.add(clientLocalFile);
        }
        return sgaFileSelected;
    }

    private static ClientSGAFile browseSingleInSaveMode(Window window, String title, Collection<String> fileTypes, String defaultFileType, boolean allowAll, ClientSGAFile currentDirectory, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setCurrentDirectory((ClientFile)currentDirectory);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.SAVE);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        ArrayList<String> allFileTypes = new ArrayList<String>();
        if (defaultFileType != null) {
            allFileTypes.add(defaultFileType);
        }
        for (String string : fileTypes) {
            if (allFileTypes.contains(string)) continue;
            allFileTypes.add(string);
        }
        ClientFileSingleTypeFilter defaultFilter = null;
        for (String fileType : allFileTypes) {
            ClientFileSingleTypeFilter filter = new ClientFileSingleTypeFilter(fileType);
            filters.add(filter);
            if (defaultFileType == null || !defaultFileType.equals(fileType)) continue;
            defaultFilter = filter;
        }
        if (allFileTypes.size() > 1) {
            filters.add(new ClientFileMultipleTypesFilter(allFileTypes));
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (defaultFilter != null) {
            chooser.setSelectedFilter(defaultFilter);
        }
        chooser.setVisible(true);
        String[] stringArray = chooser.getSelectedSavePath();
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        String path = ClientSGAFileChooserUtil.buildAbsolutePath(stringArray, currentDirectory.getSeparator());
        ClientSGAFile clientSGAFile = new ClientSGAFile(currentDirectory.getSGAName(), path);
        if (selectionMode == ClientFileChooserSelectionMode.DIRECTORIES_ONLY) {
            clientSGAFile.setDir(true);
        }
        return clientSGAFile;
    }

    private static String buildAbsolutePath(String[] path, String separator) {
        StringBuilder absolutePath = new StringBuilder();
        for (String p : path) {
            if (p.trim().isEmpty()) continue;
            absolutePath.append(separator);
            absolutePath.append(p);
        }
        return absolutePath.toString();
    }
}

