package csbase.client.algorithms;

/**
 * Listener que  usado para receber evento indicando a mudana na 
 * seleo de um algoritmo ou de uma verso de algoritmo.
 * Os objetos que implementam essa interface so registrados em 
 * <code>AlgorithmChooserPanel</code>.
 *
 */
public interface AlgorithmChooserListener {
  /**
   * Notifica que houve uma mudana na seleo de um algoritmo.
   * @param event o evento da mudana
   */
  void wasChangedAlgorithm(AlgorithmChooserEvent event);
  
  /**
   * Notifica que houve uma mudana na seleo de uma verso de algoritmo.
   * @param event o evento da mudana
   */
  void wasChangedVersion(AlgorithmChooserEvent event);
}
