package csbase.client.algorithms.commands.newview;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;

import javax.swing.JComponent;
import javax.swing.JPanel;

import tecgraf.javautils.gui.GBC;
import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.AbstractTab;
import csbase.logic.algorithms.AlgorithmConfigurator;

/**
 * Aba para visualizar os valores dos parmetros de um configurador.
 */
class ParametersTab extends AbstractTab {

  /**
   * Painel principal da aba.
   */
  private JPanel mainPanel;

  /**
   * Construtor
   * 
   * @param configurator o configurador do algoritmo executado pelo comando.
   * @param title o ttulo da aba.
   * @param owner A janela que contm essa aba.
   * @throws ClientException se houver problemas na criao do configurador.
   */
  ParametersTab(final AlgorithmConfigurator configurator, String title,
    Window owner) throws ClientException {
    super(TabType.STATIC, title, owner);

    mainPanel = new JPanel();
    mainPanel.setLayout(new GridBagLayout());

    AlgorithmConfiguratorFactory configuratorFactory =
      AlgorithmConfiguratorFactory.getInstance();
    AlgorithmConfiguratorView view =
      configuratorFactory.createReportView(owner, configurator);
    if (view != null) {
      JComponent component = view.getMainComponent();
      mainPanel.add(component, new GBC().northwest().both());
    }

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getMainComponent() {
    return mainPanel;
  }

}
