package csbase.client.algorithms.validation;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.validation.Validation;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

/**
 * Painel que mostra em forma de lista todos os subresultados de uma validao
 * 
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ValidationResultPanel extends JPanel {

  /**
   * Construtor que mostra todos os n primeiros erros.
   * 
   * @param validation A validao a ser mostrada
   * @param n quantidade de mensagens a serem montadas.
   */

  public ValidationResultPanel(Validation validation, int n) {
    List<ValidationTranslator.StatusMessage> messages = ValidationTranslator
      .recursiveTranslateMessage(validation, null);

    if (messages == null || messages.size() <= 0) {
      return;
    }

    this.setLayout(new GridBagLayout());

    if (messages.size() <= n) {
      List<JLabel> labels = recursiveBuildLabels(validation, null);
      int y = 0;
      for (JLabel label : labels) {
        this.add(label, new GBC(0, y).horizontal().west().insets(0, 0, 0, 0));
        y++;
      }
      return;
    }

    int y = 0;
    JLabel firstRow = new JLabel(LNG.get(
      "ValidationResultPanel.n.result.message", messages.size()));
    if (validation.isWellSucceeded()) {
      firstRow.setIcon(ApplicationImages.ICON_WARNING_16);
    }
    else {
      firstRow.setIcon(ApplicationImages.ICON_ERROR_16);
    }

    this.add(firstRow, new GBC(0, y).horizontal().west().insets(0, 0, 0, 0));
    y++;

    for (int i = 0; i < n; i++) {
      JLabel label = new JLabel("<html>&#x25AA;&nbsp;&nbsp;" + messages.get(
        i).message);

      this.add(label, new GBC(0, y).horizontal().west().insets(2, 18, 0, 0));
      y++;
    }

    JLabel lastRow = new JLabel("+ " + (messages.size() - n));
    this.add(lastRow, new GBC(0, y).horizontal().west().insets(2, 18, 0, 0));
  }

  /**
   * Construtor que mostra todos os erros.
   * 
   * @param validation A validao a ser mostrada
   */

  public ValidationResultPanel(Validation validation) {
    List<JLabel> labels = recursiveBuildLabels(validation, null);

    this.setLayout(new GridBagLayout());
    JLabel introduction = new JLabel(LNG.get(
      "ValidationResultPanel.full.result.message"));
    this.add(introduction, new GBC(0, 0).horizontal().west().insets(2, 0, 12,
      0));

    int y = 1;
    for (JLabel label : labels) {
      this.add(label, new GBC(0, y).horizontal().west().insets(4, 0, 0, 0));
      y++;
    }
    this.add(new JLabel(), new GBC(0, y).horizontal().west().insets(12, 0, 0,
      0));
  }

  /**
   * Monta a lista de rtulos varrendo o resultado em profundidade
   * 
   * @param validation O resultado da validao
   * @param prefix O prefixo a ser includo (nome do n)
   * @return A lista de rtulos
   */
  private List<JLabel> recursiveBuildLabels(Validation validation,
    String prefix) {
    List<JLabel> labels = new ArrayList<>();

    List<ValidationTranslator.StatusMessage> messages = ValidationTranslator
      .recursiveTranslateMessage(validation, null);

    for (ValidationTranslator.StatusMessage message : messages) {
      JLabel label = new JLabel(message.message);
      if (message.status)
        label.setIcon(ApplicationImages.ICON_WARNING_16);
      else
        label.setIcon(ApplicationImages.ICON_ERROR_16);
      labels.add(label);
    }

    return labels;
  }
}
