package csbase.client.applications.algorithmsmanager.models;

import java.util.SortedSet;

import tecgraf.javautils.gui.tree.DefaultNode;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryTreeView;
import csbase.logic.algorithms.Category;

/**
 * Representa o n raiz da rvore de dados, que efetivamente constri a rvore a
 * partir do seus ns e filhos.
 * 
 */
public final class CategoryTreeRootNode extends DefaultNode implements
  CategoryNodeInterface {

  /** Todos as categorias do n raiz */
  private SortedSet<Category> allNodes;

  /**
   * Constri a rvore de dados a partir do n raiz.
   * 
   * @param allNodes conjunto de ns da rvore de dados
   */
  public CategoryTreeRootNode(SortedSet<Category> allNodes) {
    super(CategoryTreeView.ROOT_NAME, FiltrageMode.IGNORE);
    this.allNodes = allNodes;
    for (Category node : allNodes) {
      addChild(new CategoryTreeNode(node));
    }
  }

  /**
   * Obtm o nome do n raiz de categorias.
   * 
   * @return o nome do n raiz de categorias
   */
  public String getName() {
    return CategoryTreeView.ROOT_NAME;
  }

  @Override
  public int compare(Category node) {
    return 0;
  }

  @Override
  public Category getNode() {
    return null;
  }

  @Override
  public SortedSet<Category> getSubNodes() {
    return allNodes;
  }

  @Override
  public String getFullName() {
    return getName();
  }

  @Override
  public String getId() {
    return null;
  }

  @Override
  public boolean isRootNode() {
    return true;
  }

}