package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.parameters.ParameterRegistry;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.remote.ClientRemoteLocator;

/**
 * Classe que cria e armazena um conjunto de parameters para ser usado como
 * source de um teste
 *
 * @author Tecgraf/PUC-Rio
 */
@SuppressWarnings("rawtypes")
public class ParameterStructureSource implements
  Iterable<ParameterStructure<?>> {

  /**
   * Lista de classes dos parmetros disponveis.
   */
  private final List<ParameterStructure<?>> parameters;

  /**
   * Construtor
   *
   * @param app a aplicao
   */
  public ParameterStructureSource(Application app) {
    RemoteTask<List<ParameterStructure<?>>> task =
      new RemoteTask<List<ParameterStructure<?>>>() {

        @Override
        protected void performTask() throws Exception {
          ParameterRegistry registry =
            ClientRemoteLocator.algorithmService.getParameterRegistry();
          Map<String, ParameterFactory> factories =
            registry.getParameterFactories();
          List<ParameterStructure<?>> params = new ArrayList<>();

          int i = 0;
          int n = factories.size();
          for (ParameterFactory factory : factories.values()) {
            setProgressStatus(i * 100 / n);
            params.addAll(factory.getParameterStructures());

            i++;
          }
          setResult(params);
        }
      };

    task.execute(app.getApplicationFrame(),
      app.getClassString(getClass(), "task.title"),
      app.getClassString(getClass(), "task.description"), true, false);

    if (task.getStatus()) {
      parameters = task.getResult();
    }
    else {
      parameters = new ArrayList<>();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Iterator<ParameterStructure<?>> iterator() {
    return parameters.iterator();
  }

}
