package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.rmi.RemoteException;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

/**
 * Ao que exporta um arquivo de release notes.
 */
public class ExportReleaseNotesFile extends AbstractExportFileAction {

  /** Verso de origem do arquivo a ser exportado. **/
  private AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso de origem do arquivo a ser exportado.
   * @param file Arquivo de documentao a ser exportado.
   */
  public ExportReleaseNotesFile(VersionTree tree, AlgorithmVersionInfo version,
    FileInfo file) {
    super(tree, LNG.get("algomanager.menu.release.notes.export"), file);

    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected RemoteFileChannelInfo prepareDownload(FileInfo source)
    throws RemoteException {
    return ClientRemoteLocator.algorithmService.prepareDownloadNotesFile(version
      .getInfo().getId(), version.getId(), source.getPath());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void appletExport(FileInfo source) {
    String filePath = FileUtils.joinPath('/', version.getVersionsDirName(),
      version.getDirectory(), version.getReleaseNotesDirName(), source
        .getPath());
    String dialogTitle = LNG.get("algomanager.title.notes.management");
    export(version.getInfo().getId(), filePath, dialogTitle);
  }

}
