/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.net.URL;
import java.rmi.RemoteException;

import javax.swing.JFileChooser;

import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao de importao de configuradores.
 */
public class ImportConfigurationFile extends AbstractImportFileAction {

  /**
   * Verso que ir receber o configurador.
   */
  private final AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree Fonte da ao.
   * @param version verso de destino dos arquivos importados.
   */
  public ImportConfigurationFile(VersionTree tree, AlgorithmVersionInfo version) {

    super(tree, LNG.get("algomanager.menu.config.add"),
      JFileChooser.FILES_AND_DIRECTORIES, true);

    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Task<Boolean> createCheckFileExistenceTask(final String fileName) {
    return new RemoteTask<Boolean>() {
      @Override
      protected void performTask() throws Exception {
        AlgorithmInfo algorithm = version.getInfo();
        setResult(ClientRemoteLocator.algorithmService.configFileExists(
          algorithm.getId(), version.getId(), fileName));
      }
    };
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected RemoteFileChannelInfo prepareUpload(String fileName,
    boolean isZipLocalFile) throws RemoteException {
    AlgorithmInfo algorithm = version.getInfo();
    /*
     * Se o arquivo for do tipo ZipLocalFile, devemos informar que ele deve ser
     * descompactado assim que for carregado no servidor.
     */
    return ClientRemoteLocator.algorithmService.prepareUploadConfigFile(
      algorithm.getId(), version.getId(), fileName, isZipLocalFile);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void appletUpload() {
    new UploadConfiguratorDialog().uploadConfigurator();
  }

  /**
   * Classe que representa um dilogo para carregamento de configuradores no
   * servidor a partir do cliente.
   * 
   * @author Leonardo Barros
   */
  private class UploadConfiguratorDialog extends VersionDialog {

    /**
     * Cria o dilogo.
     */
    public UploadConfiguratorDialog() {
      super(version.getInfo());
    }

    /**
     * Chama o browser para upload do configurador. O upload s est disponvel
     * quando os recursos externos esto habilitados.
     */
    public void uploadConfigurator() {
      Object algoId = algoInfo.getId();
      if (ExternalResources.getInstance().isEnabled()) {
        String addr =
          AlgorithmManagementProxy.getConfiguratorURL(algoId, version.getId(),
            getWindow());
        if (addr == null) {
          return;
        }
        try {
          final URL url = new URL(addr);
          ExternalResources.getInstance().showDocument(url);
        }
        catch (Exception ex) {
          StandardErrorDialogs.showErrorDialog(getWindow(), dialogTitle,
            LNG.get("PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), ex);
        }
      }
      else {
        StandardDialogs.showInfoDialog(getWindow(), dialogTitle,
          LNG.get("algomanager.error.upload_not_available"));
      }
    }
  }
}
