/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandDetailsFrame;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;

/**
 * Mostra detalhes de um nico comando selecionado.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ShowCommandDetailsAction extends AbstractCommandsAction {

  /**
   * Construtor.
   * 
   * @param application Aplicao que detm essa ao.
   */  
  public ShowCommandDetailsAction(CommandsMonitor application) {
    super(application, false, ApplicationImages.ICON_DETAILS_16);
  }

  /**
   * Filtro indicando que esta ao aceita qualquer comando que no esteja no
   * estado {@link CommandStatus#SCHEDULED agendado} ou no estado
   * {@link CommandStatus#SYSTEM_FAILURE falha no sistema}. {@inheritDoc}
   */  
  @Override
  protected boolean accept(CommandInfo command) {
    return command.getStatus() != CommandStatus.SCHEDULED
    && command.getStatus() != CommandStatus.SYSTEM_FAILURE;
  }
  
  /**
   * Mostra detalhes do comando selecionado.
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    CommandInfo command = getSelectedCommand();
    CommandDetailsFrame.showCommandDetailsFrame(command.getProjectId(), command
      .getId(), command.getSGAName(), getApplication());
  }
}
