/*
 * $Id: CloseLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import javax.swing.JComponent;
import javax.swing.JOptionPane;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.csvviewer.CSVViewer;

/**
 * Ao de configurar o nmero de linhas que devem ser consideradas como
 * cabealho do CSV.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class HeaderConfigurationAction extends AbstractCSVAction {

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  public HeaderConfigurationAction(CSVViewer application) {
    super(application, ApplicationImages.ICON_TABLE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    CSVViewer application = getApplication();
    String message =
      getApplication().getString(
        getClass().getSimpleName() + ".lineInput.message");
    String value =
      JOptionPane.showInputDialog(message, application.getNumRowsAsHeader());
    try {
      if (value != null) {
        int lines = Integer.valueOf(value.trim());
        application.setNumRowsAsHeader(lines);
      }
    }
    catch (Exception e) {
      String errorMsg =
        getApplication().getString(
          getClass().getSimpleName() + ".invalid.message");
      StandardDialogs.showErrorDialog(application.getApplicationFrame(),
        getName(), errorMsg);
    }
  }
}
