/*
 * $Id: DesktopLauncherUI.java 109242 2010-08-18 20:35:34Z clinio $
 */
package csbase.client.applications.desktoplauncher;

import java.util.Date;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;

/**
 * Utilitrio de UI.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DesktopLauncherUI {

  /**
   * Consulta a imagem de direo.
   * 
   * @param direction direo.
   * @return imagem
   */
  public static ImageIcon getDirectionIcon(
    final DesktopLauncherEventDirection direction) {
    switch (direction) {
      case INPUT:
        return ApplicationImages.ICON_IMPORT_16;

      case OUTPUT:
        return ApplicationImages.ICON_EXPORT_16;
    }
    return null;
  }

  /**
   * Formatao de data/hora
   * 
   * @param date data
   * @return o texto.
   */
  public static String formatDate(final Date date) {
    final String fmt = "%1$tH:%1$tM:%1$tS:%1$tL - %1$td/%1$tm";
    final String timeStr = String.format(fmt, date);
    return timeStr;
  }
  
  /**
   * Consulta imagem associada ao tratamento
   * 
   * @param treated flag
   * @return imagem
   */
  public static ImageIcon getTreatedIcon(final boolean treated) {
    return treated ? ApplicationImages.ICON_OK_16
      : ApplicationImages.ICON_CANCEL_16;
  }
}
