/*
 * $Id: FileExchangerAction.java 147234 2013-11-25 18:20:55Z oikawa $
 */

package csbase.client.applications.fileexchanger.actions.core;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.FileExchangerUI;

/**
 * Ao genrica do programa ProjectsManager
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract public class FileExchangerAction extends
  AbstractSimpleApplicationAction<FileExchanger> {

  /**
   * Construtor.
   * 
   * @param fileExchanger aplicao.
   */
  public FileExchangerAction(FileExchanger fileExchanger) {
    super(fileExchanger);
  }

  /**
   * Construtor.
   * 
   * @param fileExchanger aplicao.
   * @param icon cone.
   */
  public FileExchangerAction(FileExchanger fileExchanger, ImageIcon icon) {
    super(fileExchanger, icon);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(final ActionEvent ae) {
    try {
      actionDone();
    }
    catch (Exception e) {
      FileExchangerUI.handleException(getApplication(), e);
    }
  }

  /**
   * Ao efeitiva a ser determinada pelas sub-classes
   * 
   * @throws Exception se houver falha na operao.
   */
  abstract public void actionDone() throws Exception;
}
