package csbase.client.applications.fileexchanger.logic;

import java.io.File;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;

/**
 * Operao de exportao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ExchangeExport extends Exchange {

  /**
   * Define o filtro usado para decidir quais arquivos de um diretrio devem ser
   * exportados.
   */
  private ProjectFileFilter filter = null;

  /**
   * @return Filtro usado para exportar um diretrio.
   */
  public ProjectFileFilter getFilter() {
    return filter;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ExchangeExportThread createThread() {
    return new ExchangeExportThread(this);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String toString() {
    final ClientProjectFile remoteFile = getRemoteFile();
    final File localFile = getLocalFile();
    return remoteFile.getName() + " \u2192 " + localFile.getAbsolutePath();
  }

  /**
   * Construtor
   * 
   * @param transferMode modo de transferncia
   * @param blockSize tam. do bloco.
   * @param localFile arquivo local
   * @param remoteFile arquivo remoto.
   * @param project projeto remoto.
   * @param filter filtro usado para exportar diretrios.
   */
  public ExchangeExport(final ExchangeMode transferMode,
    final BlockSize blockSize, final File localFile,
    final ClientProjectFile remoteFile, final CommonClientProject project,
    ProjectFileFilter filter) {
    super(ExchangeType.EXPORT, transferMode, blockSize, localFile, remoteFile,
      null, (remoteFile.isDirectory() ? -1 : remoteFile.size()), project);
    // O filtro s  considerado se o arquivo  um diretrio.
    if (remoteFile.isDirectory())
      this.filter = filter;
  }
}
