package csbase.client.applications.fileexchanger.logic;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.util.AnimatedIcon;

/**
 * Estado de uma operao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum ExchangeState {

  /** Criado apenas, (estado inicial) */
  CREATED,

  /** Na fila de transferncia do programa */
  QUEUED,

  /** Em andamento */
  RUNNING(true),

  /** Terminado com sucesso */
  FINISHED,

  /** Interrompido */
  INTERRUPTED,

  /** Em pausa */
  PAUSED,

  /** Em estado de erro */
  ERROR,

  /**
   * Estado de retirado da lista de programa (seja por trmino bem sucedido ou
   * no)
   */
  REMOVED;

  /** Indica se o cone que representa esse estado deve ser animado. */
  private boolean hasAnimatedIcon;

  /** Construtor */
  ExchangeState() {
    this(false);
  }

  /**
   * Construtor.
   * 
   * @param hasAnimatedIcon Indica se o cone que representa esse estado deve
   *        ser animado.
   */
  ExchangeState(boolean hasAnimatedIcon) {
    this.hasAnimatedIcon = hasAnimatedIcon;
  }

  /**
   * Consulta o texto da descrio.
   * 
   * @return texto.
   */
  public String getDescription() {
    String className = getClass().getSimpleName();
    String tag = String.format("%s.%s.description", className, toString());
    return FileExchangerUI.getString(tag);
  }

  /**
   * Obtem a imagem que representa o estado.
   * 
   * @return imagem.
   */
  public Icon getImage() {
    String prefixTag = getPrefixTag();
    String path = String.format("states/%s.16.gif", prefixTag);
    ImageIcon imageIcon = FileExchanger.getImageIcon(FileExchanger.class, path);
    if (imageIcon != null) {
      if (isAnimated()) {
        return new AnimatedIcon(imageIcon);
      }
      return imageIcon;
    }
    return null;
  }

  /**
   * Obtem prefixo de tag.
   * 
   * @return prefixo.
   */
  private String getPrefixTag() {
    String className = getClass().getSimpleName();
    String prefixTag = String.format("%s.%s", className, toString());
    return prefixTag;
  }

  /**
   * Retorna verdadeiro se o cone que representa este estado  animado ou
   * falso, caso contrrio.
   * 
   * @return verdadeiro se o cone  animado ou falso, caso contrrio.
   */
  private boolean isAnimated() {
    return hasAnimatedIcon;
  }
}
