package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchangerUI;

/**
 * Tipo de operao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum ExchangeType {

  /** Importao */
  IMPORT,

  /** Exportao */
  EXPORT;

  /**
   * Consulta o texto da descrio.
   * 
   * @return texto
   */
  public String getDescription() {
    String className = getClass().getSimpleName();
    String tag = String.format("%s.%s.description", className, toString());
    return FileExchangerUI.getString(tag);
  }
}
