package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ToggleDotFilterRemoteAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientRemotePanel remotePanel =
      application.getRemotePanel();
    final boolean dotFiltered = remotePanel.isDotFiltered();
    remotePanel.setDotFiltered(!dotFiltered);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application a aplicao.
   */
  public ToggleDotFilterRemoteAction(final FileTransferClient application) {
    super(application);
  }
}
