/*
 * $Id: AllCategoryTreeNode.java 69264 2007-10-22 16:02:40Z lmoreira $
 */
package csbase.client.applications.flowapplication;

import static csbase.logic.algorithms.AlgorithmInfo.HIDE_ALGORITHM_PROPERTY;
import static csbase.logic.algorithms.AlgorithmInfo.HIDE_ALGORITHM_VALUE;

import java.util.SortedSet;

import javax.swing.Icon;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.tree.DefaultNode;

/**
 * Categorias (ns de rvore)
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class AllCategoryTreeNode extends DefaultNode {

  /**
   * Construtor
   * 
   * @param allCategories categorias
   * @param uncategorizedAlgorithms algoritmos sem categorizao.
   * @param showVersions Indica se devem ser mostradas as verses dos algoritmos
   *        na rvore.
   */
  public AllCategoryTreeNode(final SortedSet<Category> allCategories,
    final SortedSet<AlgorithmInfo> uncategorizedAlgorithms,
    boolean showVersions) {
    super(LNG.get("AllCategoryTreeNode.label"), FiltrageMode.IGNORE);
    for (final Category category : allCategories) {
      addChild(new CategoryTreeNode(category, showVersions));
    }
    for (final AlgorithmInfo algorithm : uncategorizedAlgorithms) {
      if (!HIDE_ALGORITHM_VALUE.equals(algorithm.getPropertyValue(
        HIDE_ALGORITHM_PROPERTY))) {
        addChild(new AlgorithmTreeNode(algorithm, showVersions));
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Icon getIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final AllCategoryTreeNode other = (AllCategoryTreeNode) obj;
    if (!getLabel().equals(other.getLabel())) {
      return false;
    }
    return true;
  }

}
