package csbase.client.applications.flowapplication;

/**
 * Ponto cardeal.
 */
public final class CompassDirection {
  /**
   * Norte.
   */
  public static final CompassDirection NORTH = new CompassDirection(1);

  /**
   * Sul.
   */
  public static final CompassDirection SOUTH = new CompassDirection(2);

  /**
   * Leste.
   */
  public static final CompassDirection EAST = new CompassDirection(3);

  /**
   * Oeste.
   */
  public static final CompassDirection WEST = new CompassDirection(4);

  /**
   * Nordeste.
   */
  public static final CompassDirection NORTH_EAST = new CompassDirection(5);

  /**
   * Noroeste.
   */
  public static final CompassDirection NORTH_WEST = new CompassDirection(6);

  /**
   * Sudeste.
   */
  public static final CompassDirection SOUTH_EAST = new CompassDirection(7);

  /**
   * Sudoeste.
   */
  public static final CompassDirection SOUTH_WEST = new CompassDirection(8);

  /**
   * Identificador.
   */
  private final int id;

  /**
   * Cria um ponto cardeal usando o identificador passado.
   * 
   * @param id O identificador.
   */
  private CompassDirection(final int id) {
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(final Object object) {
    if (object == null) {
      return false;
    }
    if (!(object instanceof CompassDirection)) {
      return false;
    }
    final CompassDirection compassDirection = (CompassDirection) object;
    return compassDirection.id == this.id;
  }

  /**
   * Obtm identificador do ponto cardeal.
   * 
   * @return O identificador do ponto cardeal.
   */
  public int getId() {
    return this.id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return this.id;
  }
}
