package csbase.client.applications.flowapplication;

import javax.swing.ImageIcon;

/**
 * Utilitrio de interface grfica.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FlowApplicationUI {

  /**
   * cone do layout de largura uniforme.
   */
  final public static ImageIcon UNIFORM_SIZE_LAYOUT_ICON = getImageIcon(
    "uniform_size_layout.16.gif");

  /**
   * cone do layout de coluna nica.
   */
  final public static ImageIcon SINGLE_COLUMN_LAYOUT_ICON = getImageIcon(
    "single_column_layout.16.gif");

  /**
   * cone genrico de layout.
   */
  final public static ImageIcon GENERIC_LAYOUT_ICON = getImageIcon(
    "generic_layout.16.gif");

  /**
   * cone de ligao ortogonal.
   */
  final public static ImageIcon ORTHOGONAL_LINK_ICON = getImageIcon(
    "orthogonal_link.16.gif");

  /**
   * cone da ao de copiar um n.
   */
  final public static ImageIcon COPY_NODE_ICON = getImageIcon(
    "copy_node.16.gif");

  /**
   * cone da ao de colar um n.
   */
  final public static ImageIcon PASTE_NODE_ICON = getImageIcon(
    "paste_node.16.gif");

  /**
   * cone de rtulo.
   */
  final public static ImageIcon LABEL_ICON = getImageIcon("label.16.png");

  /**
   * Icone do boto que faz a rvore de algoritmos voltar a seu estado inicial.
   */
  final public static ImageIcon ORIGINAL_STATE_ICON = getImageIcon(
    "original_state.16.png");

  /**
   * Busca uma imagem da aplicao.
   * 
   * @param path o path da imagem na aplicao.
   * @return a imagem buscada do <i>application manager</i>
   */
  final private static ImageIcon getImageIcon(final String path) {
    return FlowApplication.getImageIcon(FlowApplication.class, path);
  }

}
