package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.logic.ClientProjectFile;

/**
 * Ao carregar grafo de projeto. Ao que facilita utilizar o mtodo
 * {@link FlowApplication#openGraph(csbase.logic.ClientFile) }.
 */
public final class LoadProjectAction extends FlowApplicationAction {
  /**
   * Cria uma ao.
   *
   * @param application A aplicao.
   */
  public LoadProjectAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_OPEN_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    final FlowApplication app = getApplication();
    try {
      final String defType = app.getDefaultFileType();
      final ClientProjectFile file = app.browseFileOpen(defType);
      app.openGraph(file);
    }
    catch (ApplicationException ex) {
      app.showExceptionStack(ex);
    }
  }
}
