package csbase.client.applications.flowapplication.graph.actions;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import tecgraf.javautils.core.lng.LNG;

/**
 * <p>
 * A ao adiciona algumas facilidades a idia do javax.swing.Action.
 * </p>
 * <p>
 * Ela facilita a atribuio de teclas de atribuio. Ela facilita a obteno e
 * dicas. Ela interage com o mecanismo de internacionalizao do CSBase para
 * obter as mensagens para o usurio.
 * </p>
 * 
 * @author lmoreira
 */
public abstract class Action extends AbstractAction {
  /**
   * Cria uma ao.
   * 
   * @param nameKey A chave utilizada no mecanismo de internacionalizao para
   *        obter o rtulo e a dica usada na ao.
   * @param icon O cone da ao.
   */
  protected Action(String nameKey, ImageIcon icon) {
    putValue(NAME, LNG.get(nameKey));
    putValue(SMALL_ICON, icon);
  }

  /**
   * Cria uma ao.
   * 
   * @param nameKey A chave utilizada no mecanismo de internacionalizao para
   *        obter o rtulo e a dica usada na ao.
   * @param icon O cone da ao.
   * @param acceleratorKeyStroke A tecla de acelerao para executar a ao.
   */
  protected Action(String nameKey, ImageIcon icon,
    KeyStroke acceleratorKeyStroke) {
    this(nameKey, icon);
    putValue(ACCELERATOR_KEY, acceleratorKeyStroke);
  }

  /**
   * Obtm a dica.
   * 
   * @return A dica.
   */
  public final String getToolTipText() {
    return (String) getValue(NAME);
  }
}
