package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.utils.GraphNodeUpdateOperation;

/**
 * Ao de menu popup que atualiza a verso do algoritmo do n escolhido para
 * utilizar a sua verso mais atual.
 * 
 * @author isabella
 */
public class UpdateVersionAction extends GraphElementAction {

  /**
   * Cria a ao
   * 
   * @param node N a ser atualizado
   */
  protected UpdateVersionAction(final GraphNode node) {
    super(node, UpdateVersionAction.class.getName() + ".name",
      ApplicationImages.ICON_REFRESH_16);
    setEnabled(GraphNodeUpdateOperation.hasNewerVersion(node));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent event) {
    final GraphNode node = (GraphNode) getElement();
    final GraphNodeUpdateOperation operation =
      new GraphNodeUpdateOperation(node);
    final boolean result = operation.update();
    if (!result) {
      showErrorDialog(MessageFormat.format(
        LNG.get(UpdateVersionAction.class.getName() + ".error"),
        node.getAlgorithmName()));
    }
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    return new AddNodePopupActionFilter(workspace) {

      @Override
      protected Action createAction(final GraphNode graphNode,
        final Point2D point) {
        return new UpdateVersionAction(graphNode);
      }
    };
  }
}
