package csbase.client.applications.flowapplication.messages;

import java.awt.geom.Point2D;

import tecgraf.vix.Message;
import csbase.client.applications.flowapplication.graph.GraphElement;

public final class SelectElementMessage extends Message {
  private GraphElement element;
  private Point2D point;

  public SelectElementMessage(final GraphElement element, final Point2D point) {
    setElement(element);
    setPoint(point);
  }

  public GraphElement getElement() {
    return this.element;
  }

  public Point2D getPoint() {
    return this.point;
  }

  private void setElement(final GraphElement element) {
    if (element == null) {
      throw new IllegalArgumentException("O parmetro element est nulo.");
    }
    this.element = element;
  }

  private void setPoint(final Point2D point) {
    if (point == null) {
      throw new IllegalArgumentException("O parmetro point est nulo.");
    }
    this.point = point;
  }
}
