package csbase.client.applications.flowapplication.multiflow;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationComponentDialog;
import csbase.logic.ClientFile;

/**
 * Janela base para as operaes de seleo de arquivo de configurao para
 * execuo de mltiplos fluxos.
 */
public abstract class AbstractMultipleFlowConfigurationDialog extends
  ApplicationComponentDialog<Application> {

  /**
   * Tipo do arquivo de configurao.
   */
  protected static final String CONFIGURATION_FILE_TYPE = "MFLX";

  /**
   * Indica se a operao foi confirmada pelo usurio.
   */
  private boolean confirmed;

  /** O arquivo de configurao selecionado. */
  protected ClientFile configurationFile;

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   * @param configFile o arquivo selecionado.
   */
  public AbstractMultipleFlowConfigurationDialog(Application application,
    ClientFile configFile) {
    super(application);
    this.configurationFile = configFile;
    setConfirmed(false);
  }

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   */
  public AbstractMultipleFlowConfigurationDialog(Application application) {
    this(application, null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setVisible(boolean visible) {
    if (visible) {
      createUI();
      setTitle(getClassString("windowTitle"));
    }
    super.setVisible(visible);
  }

  /**
   * Cria os componentes da janela.
   */
  protected void createUI() {
    this.setLayout(new BorderLayout());
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    JComponent contentPanel = createMainComponent();
    this.add(contentPanel, BorderLayout.CENTER);
    JPanel buttonPanel = createButtonPanel();
    this.add(buttonPanel, BorderLayout.SOUTH);
    pack();
    setMinimumSize(getPreferredSize());
    validate();
  }

  /**
   * Cria o painel com os campos da janela.
   * 
   * @return o painel.
   */
  protected abstract JComponent createMainComponent();

  /**
   * Cria o painel com botes de confirmao / cancelamento.
   * 
   * @return o painel.
   */
  private JPanel createButtonPanel() {
    JPanel buttonPanel = new JPanel(new GridBagLayout());
    GBC gbc = new GBC().weighty(1);
    JButton okButton = new JButton(getClassString("okButton"));
    okButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        if (validateFields()) {
          setConfirmed(true);
          setVisible(false);
        }
        else {
          setConfirmed(false);
        }
      }
    });
    buttonPanel.add(okButton, gbc);
    this.getRootPane().setDefaultButton(okButton);

    JButton cancelButton = new JButton(getClassString("cancelButton"));
    cancelButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        setConfirmed(false);
        setVisible(false);
      }
    });
    buttonPanel.add(cancelButton, new GBC(gbc).gridx(1).east());
    return buttonPanel;
  }

  /**
   * Valida os campos da janela.
   * 
   * @return verdadeiro se o valores preenchidos so vlidos ou falso, caso
   *         contrrio.
   */
  protected boolean validateFields() {
    return validateFile();
  }

  /**
   * Valida o arquivo de configurao selecionado pelo usurio. Caso no seja
   * vlido, uma janela de erro  mostrada.
   * 
   * @return verdadeiro se o valor preenchido  vlido ou falso, caso contrrio.
   */
  protected boolean validateFile() {
    if (this.configurationFile == null) {
      getApplication().showError(getClassString("fileNotSelectedError"));
      return false;
    }
    else {
      return true;
    }
  }

  /**
   * Obtm o arquivo de configurao selecionado pelo usurio. O arquivo pode
   * ser local ou remoto.
   * 
   * @return configuration o arquivo de configurao selecionado ou nulo, caso a
   *         exportao tenha sido cancelada.
   */
  public ClientFile getConfigurationFile() {
    if (isConfirmed()) {
      return configurationFile;
    }
    else {
      return null;
    }
  }

  /**
   * Indica se a operao foi confirmada.
   * 
   * @return verdadeiro se a operao foi confirmada ou falso, caso contrrio.
   */
  protected boolean isConfirmed() {
    return confirmed;
  }

  /**
   * Define se a operao foi confirmada.
   * 
   * @param confirmed verdadeiro se a operao foi confirmada ou falso, caso
   *        contrrio.
   */
  protected void setConfirmed(boolean confirmed) {
    this.confirmed = confirmed;
  }

  /**
   * Atribui o arquivo de configurao selecionado.
   * 
   * @param configurationFile o arquivo de configurao.
   */
  protected void setConfigurationFile(ClientFile configurationFile) {
    this.configurationFile = configurationFile;
  }

}