/*
 * $Id:$
 */

package csbase.client.applications.projectsmanager;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlock;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.exception.PermissionException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ProjectsManagerUI {

  /**
   * cone de projeto alocado mas bloqueado.
   */
  final public static ImageIcon ALLOCATED_BLOCKED =
    getImageIcon("allocated.blocked.16.gif");

  /**
   * cone de projeto alocado livre
   */
  final public static ImageIcon ALLOCATED_FREE =
    getImageIcon("allocated.free.16.gif");

  /**
   * cone de projeto alocado mas bloqueado.
   */
  final public static ImageIcon NO_ALLOCATION =
    getImageIcon("no.allocation.16.gif");

  /**
   * cone de projeto desalocado
   */
  final public static ImageIcon DEALLOCATED =
    getImageIcon("deallocated.16.gif");

  /**
   * cone da ao de alocar.
   */
  final public static ImageIcon ALLOCATE = getImageIcon("allocate.16.gif");

  /**
   * cone de esperando desalocao
   */
  final public static ImageIcon WAITING_DEALLOCATION =
    getImageIcon("waiting_deallocation.16.gif");

  /**
   * cone de adio de usurios compartilhados.
   */
  final public static ImageIcon ADD_SHARED = getImageIcon("add_shared.16.gif");

  /**
   * cone de remoo de usurios compartilhados.
   */
  final public static ImageIcon REMOVE_SHARED =
    getImageIcon("remove_shared.16.gif");

  /**
   * Define os usurios.
   */
  final public static ImageIcon DEFINE_USERS =
    getImageIcon("define_users.16.gif");

  /**
   * cone de relatrio de ocupao geral do disco
   */
  final public static ImageIcon DISK_USE = getImageIcon("disk_use.16.gif");

  /**
   * Separador de tags.
   */
  final private static String TAG_SEPARATOR = ".";

  /**
   * 
   */
  final private static String ID = "projectsmanager";

  /**
   * Adiciona um "log" automtico ao histrico de um projeto.
   * 
   * @param commonClientProject O projeto.
   * @param blockType O tipo da operao.
   * @throws RemoteException em caso de execo de acesso remoto.
   */
  public static void addAutomaticHistoryBlock(
    final CommonClientProject commonClientProject,
    final ProjectHistoryBlockType blockType) throws RemoteException {

    final ProjectHistoryBlock phb = new ProjectHistoryBlock(blockType);

    final List<User> users = new ArrayList<User>();
    if (blockType.equals(ProjectHistoryBlockType.PROJECT_SHARED)) {

      for (final Object id : commonClientProject.getUserIdsSet()) {
        users.add(User.getUser(id));
      }

      phb.setUsers(users);
    }

    try {
      final ClientProjectFile projectFile = commonClientProject.getRoot();
      projectFile.appendDescription(phb.getHistoryBlock());
    }
    catch (final Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Mtodo que recebe um double e retorna uma string formatada representando
   * este valor.
   * 
   * @param num Double recebido.
   * @return String formatada que representa o double recebido.
   */
  public static String generateSizeStringFromDouble(final double num) {

    if (num < 0) {
      return "";
    }

    final double d;
    final String str;

    if (num < 1) {
      d = Math.round(num * 1000 * 1000) / 1000.0;
      str = String.valueOf(d) + " kb";
    }
    else if (num < 1000) {
      d = num;
      str = String.valueOf(d) + " mb";
    }
    else {
      d = num / 1000;
      str = String.valueOf(d) + " gb";
    }

    return str;
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param path o path do arquivo na aplicao.
   * @return o texto buscado direto o <i>application manager</i>
   */
  final private static ImageIcon getImageIcon(final String path) {
    return ProjectsManager.getImageIcon(ProjectsManager.class, path);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param theClass a classe de prefixo.
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static String getClassString(final Class<?> theClass,
    final String tag) {
    final String classPrefix = theClass.getSimpleName();
    final String theTag = classPrefix + TAG_SEPARATOR + tag;
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(theTag);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static String getString(final String tag) {
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(tag);
  }

  /**
   * Tratador de excees
   * 
   * @param projectsManager aplicao
   * @param e exceo
   */
  public static void handleException(final ProjectsManager projectsManager,
    final Exception e) {

    if (e instanceof PermissionException) {
      // TODO - Tratar exceo de permisso.
      return;
    }

    projectsManager.showException(projectsManager.getName(), e);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param theClass a classe de prefixo.
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static boolean hasClassString(final Class<?> theClass,
    final String tag) {
    final String classPrefix = theClass.getSimpleName();
    final String theTag = classPrefix + TAG_SEPARATOR + tag;
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.hasString(theTag);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static boolean hasString(final String tag) {
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.hasString(tag);
  }

  /**
   * Teste se uma string  vazia, ou se apenas contm espaos.
   * 
   * @param str a string a ser testada
   * @return true se a string  vazia ou apenas contm espaos
   */
  public static boolean isEmptyString(final String str) {
    if (str == null) {
      return true;
    }
    return str.trim().isEmpty();
  }
}
