package csbase.client.applications.projectsmanager.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.ProjectOccupationDialog;

/**
 * Ao que abre dilogo de ocupao de espao em disco.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenProjectOccupationDialogAction extends ProjectsManagerAction {

  /**
   * Construtor
   * 
   * @param projectsManager a aplicao
   */
  public OpenProjectOccupationDialogAction(ProjectsManager projectsManager) {
    super(projectsManager);
    if (!ProjectsManager.isCurrentUserAdmin()) {
      setEnabled(false);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final ProjectsManager projectsManager = getProjectsManager();
    final ProjectOccupationDialog pod =
      new ProjectOccupationDialog(projectsManager);
    pod.pack();
    //    pod.center();
    pod.setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_USERS_16;
  }

}
