package csbase.client.applications.serverdiagnostic.monitor;

import java.util.Enumeration;

import javax.swing.tree.DefaultMutableTreeNode;

import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;

/**
 * Implementa um n da rvore de status que atua como um grupamento de outros.
 * 
 * @author Tecgraf PUC-Rio
 */
public class StatusGroupTreeNode extends DefaultMutableTreeNode implements
  StatusTreeNode {

  /**
   * Construtor
   * 
   * @param name o nome do n
   */
  public StatusGroupTreeNode(String name) {
    super(new StatusNode(name, null, null));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public StatusGroupTreeNode addStatus(Status status, SwingRenderer renderer) {
    add(new DefaultMutableTreeNode(new StatusNode(status.getResourceName(),
      status, renderer)));
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public StatusGroupTreeNode addStatusGroup(String groupName) {
    StatusGroupTreeNode group = new StatusGroupTreeNode(groupName);
    add(group);
    return group;
  }

  /**
   * Obtm o cdigo de status de um n que representa um grupamento.
   * 
   * @return o cdigo de status
   */
  public StatusCode getStatusCode() {
    Enumeration<?> en = this.children();
    StatusCode result = StatusCode.OK;
    while (en.hasMoreElements()) {
      DefaultMutableTreeNode node = (DefaultMutableTreeNode) en.nextElement();
      StatusCode statusOfChild;
      if (StatusGroupTreeNode.class.isInstance(node)) {
        statusOfChild = StatusGroupTreeNode.class.cast(node).getStatusCode();
      }
      else {
        statusOfChild = ((StatusNode) node.getUserObject()).status.getCode();
      }
      if (statusOfChild.equals(StatusCode.ERROR)) {
        return statusOfChild;
      }
      if (statusOfChild.equals(StatusCode.WARNING)) {
        result = StatusCode.WARNING;
      }
    }
    return result;
  }
}