package csbase.client.ias;

import java.awt.LayoutManager;

import javax.swing.JPanel;

import csbase.client.ias.PermissionInfoDialog.FieldsState;
import csbase.logic.Permission;

/**
 * Classe abstrata que deve ser implementada pelos paineis que se destinam a
 * insero/alterao das propriedades especficas de uma classe de permisso.
 * 
 */
abstract class AbstractPermissionPanel extends JPanel {

  /** Dilogo no qual este painel est contido. */
  protected final PermissionInfoDialog dialog;

  /**
   * @param layout LayoutManager que ser utilizado por este painel.
   * @param dialog Dilogo no qual este painel est contido.
   */
  AbstractPermissionPanel(LayoutManager layout, PermissionInfoDialog dialog) {
    super(layout);
    this.dialog = dialog;
  }

  /**
   * Importa os valores da permisso que este painel trata para os campos deste
   * painel. Este mtodo  utilizado apenas na abertura da tela de alterao de
   * uma permisso.
   * 
   * @param permission Permisso que contm os valores que sero importados para
   *        o campos deste painel.
   */
  abstract void importFrom(Permission permission);

  /**
   * Exporta os valores inseridos nos campos deste painel para a permisso que
   * este painel trata.
   * 
   * @param permission Permisso que receber os valores exportados dos campos
   *        deste painel.
   */
  abstract void exportTo(Permission permission);

  /**
   * Limpa todos os campos do painel.
   */
  abstract void clearFields();

  /**
   * {@inheritDoc}
   */
  @Override
  public void setVisible(boolean aFlag) {
    super.setVisible(aFlag);
  }

  /**
   * Verifica se o preenchimento dos campos deste painel est correto.
   * 
   * @return Resultado da validao dos campos.
   */
  public FieldsState validateFields() {
    return FieldsState.FIELDS_OK;
  }

  /**
   * Verifica se a permisso tratada por este painel foi alterada. Este mtodo 
   * utilizado apenas na tela de alterao de uma permisso.
   * 
   * @param permission Permisso original.
   * @return True, se a permisso teve algum valor alterado. False, caso
   *         contrrio.
   */
  abstract boolean hasChanged(Permission permission);

  /**
   * Realiza as mudanas necessrias decorrentes da mudana de classe.
   */
  public void changeClass() {
    clearFields();
  }
}
