package csbase.client.preferences.editors;

import javax.swing.JComponent;
import javax.swing.JPanel;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Editor de preferncia usado quando um valor de preferncia no especifica seu
 * editor.
 * 
 * {@link PreferenceValue#getEditor()}
 * 
 * @param <T> tipo do valor editado.
 * 
 * @author Tecgraf
 */
public class EmptyEditor<T> extends PreferenceEditor<T> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public EmptyEditor(PreferenceValue<T> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    return new JPanel();
  }

}
