package csbase.client.preferences.editors;

import java.io.File;

import javax.swing.JComponent;

import csbase.client.ClientLocalFile;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel.ClientFileLocation;
import csbase.client.util.csvpanel.columns.FileChooserListener;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;

/**
 * Classe que encapsula o editor de um valor que armazena o camihno para um
 * diretrio local.
 * 
 * @author Tecgraf
 */
public class LocalDirectoryEditor extends PreferenceEditor<String> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public LocalDirectoryEditor(PreferenceValue<String> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    String value = getValue();
    ClientFile clientFile = null;
    if (value != null && !value.trim().isEmpty()) {
      File file = new File(value);
      clientFile = new ClientLocalFile(file);
    }
    ClientFileChooserType chooserType = ClientFileChooserType.OPEN;
    ClientFileChooserSelectionMode selectionMode =
      ClientFileChooserSelectionMode.DIRECTORIES_ONLY;
    ClientFileLocation location = ClientFileLocation.LOCAL_ONLY;
    ClientFileChooserTextPanel panel =
      new ClientFileChooserTextPanel(clientFile, null, null, chooserType,
        selectionMode, location);
    panel.setEnabled(isEditable());
    panel.addFileSelectionListener(new FileChooserListener() {
      @Override
      public void fileSelected(ClientFile selectedFile) {
        String filePath = selectedFile.getStringPath();
        setValue(filePath);
        notifyListeners();
      }
    });

    setTitledBorder(panel);
    return panel;
  }
}
