package csbase.client.preferences.editors;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import tecgraf.javautils.gui.GBC;
import csbase.client.facilities.configurabletable.table.ColumnState;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Classe que armazena o estado de todas as colunas de uma lista de tabelas
 * configurveis {@link ConfigurableTable}.
 * 
 * @author Tecgraf
 */
public class PVTablesEditor extends
  PreferenceEditor<Map<String, List<ColumnState>>> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public PVTablesEditor(PreferenceValue<Map<String, List<ColumnState>>> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    Map<String, List<ColumnState>> statesMap = getValue();

    JPanel allTablesPanel = new JPanel(new GridBagLayout());

    int column = 0;
    if (!statesMap.isEmpty()) {
      for (String tableId : statesMap.keySet()) {
        JPanel tablePanel = createPanel(statesMap, tableId);
        allTablesPanel.add(tablePanel, new GBC(column++, 0).north()
          .horizontal());
      }
    }
    else {
      JLabel noTables = new JLabel(getString("no.tables.defined"));
      noTables.setFont(font);
      allTablesPanel.add(noTables);
    }

    setTitledBorder(allTablesPanel);

    return allTablesPanel;
  }

  /**
   * Cria o painel que exibe as informaes de uma tabela.
   * 
   * @param statesMap - lista com os estados das colunas da tabela.
   * @param tableId - identificador da tabela.
   * @return painel.
   */
  private JPanel createPanel(final Map<String, List<ColumnState>> statesMap,
    String tableId) {
    JPanel panel = new JPanel(new GridBagLayout());

    int row = 0;
    int column = 0;

    int lineNumber = statesMap.get(tableId).size();
    if (lineNumber > 20 && lineNumber < 30) {
      lineNumber = (lineNumber % 2 == 0) ? lineNumber / 2 : lineNumber / 2 + 1;
    }
    if (lineNumber >= 30) {
      lineNumber = 15;
    }

    for (final ColumnState state : statesMap.get(tableId)) {
      String columnName = state.getColumnId();
      if (hasString(columnName)) {
        columnName = getString(columnName);
      }

      final JCheckBox checkbox = new JCheckBox(columnName);
      checkbox.setSelected(state.isVisible());
      checkbox.setFont(font);

      checkbox.addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
          state.setVisible(checkbox.isSelected());
          notifyListeners();
        }
      });

      checkbox.setEnabled(isEditable());

      String tableLabel = tableId;
      if (hasString(tableLabel)) {
        tableId = getString(tableLabel);
      }

      setTitledBorder(panel, tableLabel);
      panel.add(checkbox, new GBC(column, row++).west().left(10).right(10));
      if (row == lineNumber) {
        row = 0;
        column++;
      }
    }
    return panel;
  }
}
