/*
 * Created on Jun 15, 2004
 */
package csbase.client.project;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.logic.ClientProjectFile;

/**
 * Renderizador para nomes de arquivos.
 * 
 * @author Tecgraf
 */
public class ProjectFileCellRenderer extends DefaultTableCellRenderer {
  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    String text = "";
    ClientProjectFile file = null;
    if (value != null) {
      file = (ClientProjectFile) value;
      text = file.getName();
      if (text == null) {
        text = "";
      }
    }
    setText(text);
    setToolTipText(text);
    // O cdigo seguinte foi inserido porque no estava marcando o nome do
    // arquivo selecionado, apesar de isto ser feito na DefaultTableCellRenderer.
    if (isSelected) {
      setBackground(table.getSelectionBackground());
    }
    else {
      setBackground(table.getBackground());
    }

    if (file != null && !file.isDirectory() && file.isLocked()) {
      setForeground(Color.RED);
    }
    else {
      setForeground(table.getForeground());
    }
    return this;
  }
}
