/**
 * ProjectTreeFactory.java $Author: mjulia $ $Revision: 144754 $  - $Date:
 * 2003/07/08 20:50:53 $
 */
package csbase.client.project;

import java.awt.Window;

import csbase.client.kernel.ClientException;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;

/**
 * A classe <code>ProjectTreeFactory</code> modela uma fbrica de rvore de
 * projetos. Essa classe deve ser redefinida para que os mtodos
 * <code>makeProjectTree</code> retornem as instncias mais especializadas das
 * rvores.
 */
public class ProjectTreeFactory {
  private static ProjectTreeFactory instance = null;

  /**
   * Obtm a instncia de fbrica corrente.
   *
   * @return .
   */
  public static ProjectTreeFactory getInstance() {
    if (instance == null) {
      instance = new ProjectTreeFactory();
    }
    return instance;
  }

  /**
   * Cria uma rvore de projetos.
   *
   * @param owner .
   * @param title .
   *
   * @return .
   *
   * @throws ClientException .
   */
  public ProjectTree makeProjectTree(Window owner, String title)
  throws ClientException {
    return new ProjectTree(owner, title);
  }

  /**
   * Cria uma rvore de projetos.
   *
   * @param owner .
   * @param title .
   * @param project .
   *
   * @return .
   *
   * @throws ClientException .
   */
  public ProjectTree makeProjectTree(
    Window owner, String title, CommonClientProject project)
  throws ClientException {
    return new ProjectTree(owner, title, project);
  }

  /**
   * Cria uma rvore de projetos.
   *
   * @param owner .
   * @param title .
   * @param project .
   * @param visualFilter .
   *
   * @return .
   *
   * @throws ClientException .
   */
  public ProjectTree makeProjectTree(
    Window owner, String title, CommonClientProject project,
    ProjectFileFilter visualFilter)
  throws ClientException {
    return new ProjectTree(owner, title, project, visualFilter);
  }

  public ProjectTree makeProjectTree(
    Window owner, String title, CommonClientProject project,
    ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter)
  throws ClientException {
    return new ProjectTree(
      owner, title, project, visualFilter, selectionFilter);
  }

  /**
   * Constri uma fbrica e guarda sua instncia.
   */
  protected ProjectTreeFactory() {
    instance = this;
  }
}
