package csbase.client.project.action;

import java.awt.event.ActionEvent;

import javax.swing.JCheckBoxMenuItem;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.logic.CommonClientProject;
import tecgraf.javautils.core.lng.LNG;

/**
 * Ao que determina se datasets (diretrios com tipo associado) devem ter seu
 * contedo interno exibido.
 *
 * @author Tecgraf
 */
public class ExpandDatasetAction extends ProjectAction {

  /**
   * O nome da ao.
   *
   * FIXME: Internacionalizao.
   */
  private static final String ACTION_NAME = LNG.get("ExpandDatasetAction.name");

  /**
   * Construtor.
   *
   * @param treeView - rvore do projeto
   */
  public ExpandDatasetAction(ProjectTree treeView) {
    super(treeView);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem) e.getSource();
    DesktopFrame.getInstance().setShouldExpandDataset(menuItem.isSelected());
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        CommonClientProject currentProject = getCurrentProject();
        if (currentProject != null) {
          currentProject.refreshTree();
        }
      }
    };

    task.execute(getWindow(), getTitle(), LNG.get("PRJ_WAITING_REFRESH_TREE"));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return ACTION_NAME;
  }

}
