/*
 * $Id: CoreTask.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.tasks;

import java.awt.Window;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;

/**
 * Classe que implementa a tarefa de ajustar o out-of-date em todo projeto.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <T> o tipo do resultado da task conforme {@link RemoteTask}.
 */
abstract class CoreTask<T> extends RemoteTask<T> {

  /**
   * Mtodo interno de convenincia.
   * 
   * @param msg o texto da task.
   * @return o indicativo de
   *         {@link RemoteTask#execute(java.awt.Window, String, String)}
   */
  private boolean execute(final String msg) {
    final String className = getClass().getSimpleName();
    final String title = LNG.get(className + ".title");
    final boolean executed = execute(null, title, msg);
    return executed;
  }

  /**
   * Mtodo interno de convenincia.
   * 
   * @param window a janela-me.
   * @param msg o texto da task.
   * @return o indicativo de
   *         {@link RemoteTask#execute(java.awt.Window, String, String)}
   */
  private boolean execute(Window window, final String msg) {
    final Window owner;
    if (window == null) {
      final DesktopFrame dskFrame = DesktopFrame.getInstance();
      final DesktopComponentFrame frm = dskFrame.getDesktopFrame();
      owner = frm;
    }
    else {
      owner = window;
    }

    final String className = getClass().getSimpleName();
    final String title = LNG.get(className + ".title");

    final boolean executed = execute(owner, title, msg);
    return executed;
  }

  /**
   * Mtodo de convenincia para execuo da task com base na janela de desktop
   * e com textos ttulo e mensagem padronizados.
   * 
   * @return o indicativo de {@link #execute(String)}.
   */
  protected boolean execute() {
    final String className = getClass().getSimpleName();
    final String msg = LNG.get(className + ".msg");
    return execute(msg);
  }

  /**
   * Mtodo de convenincia para execuo da task com base na janela de desktop
   * e com textos ttulo e mensagem padronizados.
   * 
   * @param window janela-me.
   * 
   * @return o indicativo de {@link #execute(String)}.
   */
  protected boolean execute(Window window) {
    final String className = getClass().getSimpleName();
    final String msg = LNG.get(className + ".msg");
    final boolean executed = execute(window, msg);
    return executed;
  }

  /**
   * Mtodo de convenincia para execuo da task com base na janela de desktop
   * e com texto ttulo padronizado; a mensagem ser formatada conforme o
   * parmetro
   * 
   * @param args os argumentos de formatao da mensagem.
   * @return o indicativo de {@link #execute(String)}.
   */
  protected boolean execute(final Object[] args) {
    final boolean executed = execute(null, args);
    return executed;
  }

  /**
   * Mtodo de convenincia para execuo da task com base na janela de desktop
   * e com texto ttulo padronizado; a mensagem ser formatada conforme o
   * parmetro
   * 
   * @param window janela-me da task.
   * @param args os argumentos de formatao da mensagem.
   * @return o indicativo de {@link #execute(String)}.
   */
  protected boolean execute(Window window, final Object[] args) {
    final String className = getClass().getSimpleName();
    final String fmt = LNG.get(className + ".msg");
    final String msg = String.format(fmt, args);
    final boolean executed = execute(window, msg);
    return executed;
  }

}
