/* 
 * $Id$ 
 */

package csbase.client.project.tasks;

import csbase.client.desktop.RemoteTask;
import csbase.logic.ClientProjectFile;

/**
 * Tarefa para alterar o tipo de um arquivo se seu tipo for diferente do
 * almejado.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SetFileTypeTask extends RemoteTask<Void> {

  /**
   * Arquivo a ter o tipo alterado.
   */
  private ClientProjectFile file; 
  /**
   * Novo tipo do arquivo.
   */
  private String type;
  
  /**
   * Construtor.
   * 
   * @param file arquivo que ter o tipo alterado.
   * @param type novo tipo do arquivo.
   */
  public SetFileTypeTask(ClientProjectFile file, String type) {
    this.file = file;
    this.type = type;
  }
  
  /**
   * Altera o tipo do arquivo se seu tipo for diferente do almejado.
   */  
  @Override
  public void performTask() throws Exception {
    if (!file.getType().equalsIgnoreCase(type)) {
      file.changeType(type);
    }
  }
}
