package csbase.client.util.filechooser.fileparentcombopanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;

import csbase.client.util.filechooser.images.ChooserImages;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;

/**
 * Renderer
 *
 * @author Tecgraf/PUC-Rio
 */
class ClientFileParentComboRenderer extends DefaultListCellRenderer {

  /**
   * Fonte padro.
   */
  final private static Font DEFAULT_FONT = new JLabel().getFont();

  /**
   * Busca a profundidade do arquivo em sua rvore ancestral.
   *
   * @param clientFile o arquivo
   * @return o nvel (profundidade)
   */
  private int getDepth(ClientFile clientFile) {
    if (ClientFileChooserUtils.isLocalRootDirectory(clientFile)
      || ClientFileChooserUtils.isProjectHomeDirectory(clientFile)) {
      return 0;
    }
    int depth = 0;
    ClientFile f = clientFile;
    while (f != null) {
      depth++;
      f = f.getParent();
    }
    return depth;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getListCellRendererComponent(JList list, Object value,
    int index, boolean isSelected, boolean cellHasFocus) {
    final Component component =
      super.getListCellRendererComponent(list, value, index, isSelected,
        cellHasFocus);
    final JLabel label = ((JLabel) component);
    final ClientFile directory = (ClientFile) value;

    label.setIcon(ChooserImages.DIRECTORY_ICON);
    label.setForeground(Color.black);
    label.setFont(DEFAULT_FONT);
    label.setHorizontalAlignment(SwingUtilities.LEFT);
    final int left = getDepth(directory) * 10;
    label.setBorder(BorderFactory.createEmptyBorder(0, left, 0, 0));
    if (directory == null) {
      label.setText(null);
      label.setIcon(null);
    }
    else {
      String dirName = ClientFileChooserUtils.getDirectoryName(directory);
      label.setText(dirName);
      ImageIcon icon = ClientFileChooserUtils.getDirectoryImageIcon(directory);
      label.setIcon(icon);
    }
    return label;
  }
}
