/**
 * $Id: ClientFileMultipleTypesFilter.java 169707 2015-11-12 10:52:44Z lmoreira $
 */
package csbase.client.util.filechooser.filters;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.swing.ImageIcon;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.ClientProjectFileType;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;

/**
 * 
 * 
 * @author Tecgraf
 */
public class ClientFileMultipleTypesFilter implements ClientFileFilterInterface {

  /**
   * Tipos aceitos.
   */
  final private List<String> types = new ArrayList<String>();
  /**
   * Imagem dos tipos.
   */
  private final ImageIcon completeIcon;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(ClientFile file, Operation operation) {
    if (file.isDirectory() && operation == Operation.VISUALIZATION) {
      return true;
    }
    for (String type : types) {
      if (file.getType().equals(type)) {
        return true;
      }
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    String sufixes = "";
    for (String type : types) {
      ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
      final List<String> extensions = fileType.getExtensions();
      String extSufix = "(";
      for (String ext : extensions) {
        extSufix = extSufix + " *." + ext + " ";
      }
      extSufix = extSufix + ")";
      sufixes = sufixes + " " + extSufix;
    }
    final String className = this.getClass().getSimpleName();
    final String label = LNG.get(className + ".description");
    return ": " + label + " - " + sufixes;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return completeIcon;
  }

  /**
   * Mota icone com todos os tipos selecionados.
   * 
   * @return icone
   */
  private ImageIcon buildIcon() {
    ClientProjectFileType firstType =
      ClientProjectFileType.getFileType(types.get(0));
    final ImageIcon firstIcon = firstType.getBaseIcon();
    final int firstWidth = firstIcon.getIconWidth();
    final int h = firstIcon.getIconHeight();
    final int gap = 2;
    final int numTypes = types.size();
    final int w = numTypes * firstWidth + (numTypes - 1) * gap;
    BufferedImage buffImg = new BufferedImage(w, h, BufferedImage.BITMASK);
    Graphics g = buffImg.createGraphics();
    int x = 0;
    for (String type : types) {
      ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
      final ImageIcon icon = fileType.getBaseIcon();
      g.drawImage(icon.getImage(), x, 0, null);
      x = x + gap + firstWidth;
    }
    g.dispose();
    final ImageIcon imageIcon = new ImageIcon(buffImg);
    return imageIcon;
  }

  /**
   * Construtor.
   * 
   * @param types tipos aceitos em conjunto.
   */
  public ClientFileMultipleTypesFilter(String[] types) {
    this(Arrays.asList(types));
  }

  /**
   * Construtor.
   * 
   * @param types tipos aceitos em conjunto.
   */
  public ClientFileMultipleTypesFilter(Collection<String> types) {
    this.types.addAll(types);
    this.completeIcon = buildIcon();
    Collections.unmodifiableList(this.types);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectFileType inferFileType() {
    return null;
  }
}
