package csbase.client.util.iostring;

import java.nio.charset.Charset;

import csbase.client.desktop.Task;
import csbase.logic.ClientFile;

/**
 * Task especfica para leitura
 * {@link TextReader#readAllWithoutTask(ClientFile, Charset, TextDealerStatusInterface)}
 * .
 * 
 * @author Tecgraf/PUC-Rio
 */
class ReaderTask extends Task<String> implements TextDealerStatusInterface {

  /**
   * Arquivo
   */
  final private ClientFile file;

  /**
   * Charset
   */
  final private Charset charset;

  /**
   * {@inheritDoc}
   */
  @Override
  final protected void performTask() throws Exception {
    final String result = TextReader.readAllWithoutTask(file, charset, this);
    setResult(result);
  }

  /**
   * Construtor
   * 
   * @param file arquivo
   * @param charset charset
   */
  public ReaderTask(final ClientFile file, final Charset charset) {
    this.file = file;
    this.charset = charset;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isTextOperationInterrupted() {
    return wasCancelled();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setTextOperationPercentage(int perc) {
    setProgressStatus(perc);
  }

}
