/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.table;

import csbase.client.facilities.configurabletable.column.IConfigurableColumn;
import csbase.client.facilities.configurabletable.table.ColumnState;
import csbase.client.facilities.configurabletable.table.ColumnVisibilityListener;
import csbase.client.facilities.configurabletable.table.ConfigurableTableModel;
import csbase.client.facilities.configurabletable.table.RowToKey;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.filter.IFilter;
import tecgraf.javautils.gui.table.SortableTable;

public class ConfigurableTable<T>
extends SortableTable {
    private String id;
    private ConfigurableTableModel<T> model;
    private Map<String, ColumnAction> columnsActions;
    private List<ColumnVisibilityListener> columnVisibilityListeners;
    private RowToKey<T> rowToKey;

    public ConfigurableTable(String id, List<IConfigurableColumn<T>> columns, IFilter<T> filter, List<T> rows) {
        this(id, columns, filter);
        if (rows == null) {
            throw new IllegalArgumentException("rows n\u00e3o pode ser nulo.");
        }
        this.updateRows(rows);
    }

    public ConfigurableTable(String id, List<IConfigurableColumn<T>> columns, IFilter<T> filter) {
        if (id == null) {
            throw new IllegalArgumentException("id n\u00e3o pode ser nulo.");
        }
        if (columns == null) {
            throw new IllegalArgumentException("columns n\u00e3o pode ser nulo.");
        }
        this.id = id;
        ArrayList emptyList = new ArrayList();
        this.model = new ConfigurableTableModel<T>(columns, filter, emptyList);
        super.setModel(this.model);
        this.columnVisibilityListeners = new ArrayList<ColumnVisibilityListener>();
        this.setColumnsComparators();
        this.createColumnsActions();
        this.addHeaderAction();
    }

    public String getId() {
        return this.id;
    }

    public List<T> getRows() {
        return this.model.getRows();
    }

    public IFilter<T> getFilter() {
        return this.model.getFilter();
    }

    public List<T> getSelectedObjects() {
        ArrayList<T> result = new ArrayList<T>();
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                T selectedObject = this.model.getRow(this.convertRowIndexToModel(selectedRows[i]));
                result.add(selectedObject);
            }
        }
        return result;
    }

    public void setFilter(IFilter<T> filter) {
        this.model.setFilter(filter);
    }

    public void updateRows(List<T> newRows) {
        if (this.rowToKey != null) {
            Set<String> keys = this.preUpdateRows();
            this.model.setRows(newRows);
            this.model.fireTableDataChanged();
            this.posUpdateRows(keys);
        } else {
            this.model.setRows(newRows);
            this.model.fireTableDataChanged();
        }
    }

    public void updateRows() {
        if (this.rowToKey != null) {
            Set<String> keys = this.preUpdateRows();
            this.model.fireTableDataChanged();
            this.posUpdateRows(keys);
        } else {
            this.model.fireTableDataChanged();
        }
    }

    public void updateColumns() {
        int columnIndex = this.getSortedColIndexView();
        if (columnIndex != -1) {
            IConfigurableColumn<T> column = this.model.getColumn(columnIndex);
            SortOrder order = this.getCurrentSortOrder();
            this.model.fireTableStructureChanged();
            this.setColumnsComparators();
            if (column.isVisible()) {
                this.sort(columnIndex, order);
            }
        } else {
            this.model.fireTableStructureChanged();
            this.setColumnsComparators();
        }
        for (ColumnAction action : this.columnsActions.values()) {
            action.updateAllCheckBoxes();
        }
    }

    public List<ColumnState> getColumnsState() {
        return this.model.getColumnsState();
    }

    public void setColumnsState(List<ColumnState> columnsState) {
        this.model.setColumnsState(columnsState);
    }

    public List<JCheckBoxMenuItem> createColumnsCheckBoxes() {
        ArrayList<JCheckBoxMenuItem> checkboxes = new ArrayList<JCheckBoxMenuItem>();
        for (IConfigurableColumn<T> column : this.model.getAllColumns()) {
            ColumnAction action = this.columnsActions.get(column.getId());
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
            item.setText(column.getColumnName());
            item.setSelected(column.isVisible());
            action.registerJCheckBoxMenuItem(item);
            checkboxes.add(item);
        }
        return checkboxes;
    }

    public int getTotalColumnCount() {
        return this.model.getAllColumns().size();
    }

    public void addColumnVisibilityListener(ColumnVisibilityListener listener) {
        this.columnVisibilityListeners.add(listener);
    }

    public List<ColumnVisibilityListener> getColumnVisibilityListeners() {
        return this.columnVisibilityListeners;
    }

    public void setRowToKey(RowToKey<T> rowToKey) {
        this.rowToKey = rowToKey;
    }

    public void setModel(TableModel tableModel) {
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        int columnModel = this.convertColumnIndexToModel(column);
        IConfigurableColumn<T> columnImpl = this.model.getColumn(columnModel);
        TableCellRenderer columnRenderer = columnImpl.createTableCellRenderer();
        if (columnRenderer != null) {
            renderer = columnRenderer;
        }
        if (renderer != null && renderer instanceof DefaultTableCellRenderer) {
            int align = columnImpl.getAlign();
            ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(align);
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor cellEditor = super.getCellEditor(row, column);
        int columnModel = this.convertColumnIndexToModel(column);
        IConfigurableColumn<T> columnImpl = this.model.getColumn(columnModel);
        TableCellEditor editor = columnImpl.createTableCellEditor();
        if (editor != null) {
            cellEditor = editor;
        }
        return cellEditor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ConfigurableTable other = (ConfigurableTable)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getId();
    }

    protected void addHeaderAction() {
        final List<JCheckBoxMenuItem> checkboxes = this.createColumnsCheckBoxes();
        this.getTableHeader().addMouseListener(new MouseAdapter(){
            private JPopupMenu popUp;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (3 == e.getButton()) {
                    if (this.popUp == null) {
                        this.popUp = new JPopupMenu();
                        for (JCheckBoxMenuItem item : checkboxes) {
                            this.popUp.add(item);
                        }
                    }
                    this.popUp.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private Set<String> preUpdateRows() {
        HashSet<String> keys = new HashSet<String>();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            int modelIndex = this.convertRowIndexToModel(selectedRows[i]);
            T line = this.getRows().get(modelIndex);
            keys.add(this.rowToKey.getKey(line));
        }
        return keys;
    }

    private void posUpdateRows(Set<String> keys) {
        for (int i = 0; i < this.getRows().size(); ++i) {
            T line = this.getRows().get(i);
            if (!keys.contains(this.rowToKey.getKey(line))) continue;
            int index = this.convertRowIndexToView(i);
            this.addRowSelectionInterval(index, index);
        }
    }

    private void setColumnsComparators() {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            Comparator<?> comparator = this.model.getColumns().get(i).getComparator();
            if (comparator == null) continue;
            super.setComparator(i, comparator);
        }
    }

    private void createColumnsActions() {
        this.columnsActions = new HashMap<String, ColumnAction>();
        for (IConfigurableColumn<T> column : this.model.getAllColumns()) {
            ColumnAction action = new ColumnAction(column, this);
            this.columnsActions.put(column.getId(), action);
        }
    }

    private class ColumnAction
    extends AbstractAction {
        private IConfigurableColumn<?> column;
        private ConfigurableTable<?> table;
        private List<JCheckBoxMenuItem> checkboxes;

        public ColumnAction(IConfigurableColumn<?> column, ConfigurableTable<?> table) {
            this.column = column;
            this.table = table;
            this.checkboxes = new ArrayList<JCheckBoxMenuItem>();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.column.setVisible(!this.column.isVisible());
            this.table.updateColumns();
            for (ColumnVisibilityListener l : this.table.getColumnVisibilityListeners()) {
                l.visibilityChanged(this.column);
            }
        }

        public void registerJCheckBoxMenuItem(JCheckBoxMenuItem item) {
            this.checkboxes.add(item);
        }

        public void updateAllCheckBoxes() {
            for (JCheckBoxMenuItem item : this.checkboxes) {
                item.setSelected(this.column.isVisible());
            }
        }
    }
}

