/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.PlatformProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class PlatformInfoDialog {
    private DesktopComponentDialog window;
    private Window owner;
    private JTextField name;
    private JTextField description;
    private JButton modifyPlatformButton;
    private String windowLabel;
    private Platform platform;

    private JPanel makeClearButtonPanel() {
        JPanel clearPanel = new JPanel();
        JButton clearButton = new JButton(LNG.get((String)"IAS_CLEAR"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PlatformInfoDialog.this.clearFields();
            }
        });
        clearPanel.add(clearButton);
        return clearPanel;
    }

    protected void display() {
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"IAS_PLATFORM_REGISTRATION")));
        mainPane.add((Component)this.makeMainPanel(), "North");
        mainPane.add((Component)this.makeClearButtonPanel(), "South");
        JPanel backPane = new JPanel(new BorderLayout());
        backPane.add(mainPane);
        backPane.add((Component)this.makeButtonPanel(), "South");
        this.window = new DesktopComponentDialog(this.owner, this.windowLabel);
        this.window.getContentPane().add(backPane);
        this.window.setDefaultCloseOperation(2);
        this.window.pack();
        this.window.center(this.owner);
        this.window.setVisible(true);
    }

    protected void initFields() {
        this.name.setText(this.platform.getName());
        this.name.setEditable(false);
        this.description.setText(this.platform.getDescription());
        ChangeListener changeList = new ChangeListener();
        this.description.addKeyListener(changeList);
    }

    protected JPanel makeMainPanel() {
        this.name = new JTextField(20);
        JLabel nameL = new JLabel(LNG.get((String)"IAS_PLATFORM"));
        this.description = new JTextField();
        JLabel descriptionL = new JLabel(LNG.get((String)"IAS_PLATFORM_DESCRIPTION"));
        if (this.platform != null) {
            this.initFields();
        }
        GridLayout g = new GridLayout(0, 1);
        g.setVgap(10);
        JPanel textP = new JPanel();
        JPanel labels = new JPanel(g);
        JPanel texts = new JPanel(new GridLayout(0, 1));
        labels.add(nameL);
        labels.add(descriptionL);
        texts.add(this.name);
        texts.add(this.description);
        textP.add(labels);
        textP.add(texts);
        return textP;
    }

    protected JButton makeChangeButton() {
        this.modifyPlatformButton = new JButton(LNG.get((String)"IAS_PLATFORM_UPDATE"));
        this.modifyPlatformButton.setEnabled(false);
        this.modifyPlatformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (PlatformInfoDialog.this.validateFields()) {
                    PlatformInfoDialog.this.modifyPlatform();
                    PlatformInfoDialog.this.window.close();
                } else {
                    StandardErrorDialogs.showErrorDialog((Window)PlatformInfoDialog.this.window, PlatformInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                    PlatformInfoDialog.this.modifyPlatformButton.setEnabled(false);
                }
            }
        });
        return this.modifyPlatformButton;
    }

    protected JButton makeAddPlatformButton() {
        JButton addPlatformButton = new JButton(LNG.get((String)"IAS_PLATFORM_INCLUDE"));
        addPlatformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (PlatformInfoDialog.this.validateFields()) {
                    PlatformInfoDialog.this.createPlatform();
                } else {
                    StandardErrorDialogs.showErrorDialog((Window)PlatformInfoDialog.this.window, PlatformInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                }
            }
        });
        return addPlatformButton;
    }

    protected JButton makeCancelButton() {
        JButton cancelButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PlatformInfoDialog.this.window.close();
            }
        });
        return cancelButton;
    }

    protected JButton makeCloseButton() {
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected;
                String nameText = PlatformInfoDialog.this.name.getText().trim();
                String descText = PlatformInfoDialog.this.description.getText().trim();
                if (nameText.equals(PlatformInfoDialog.this.platform.getName()) && descText.equals(PlatformInfoDialog.this.platform.getDescription()) || nameText.equals("") && descText.equals("")) {
                    PlatformInfoDialog.this.window.close();
                    return;
                }
                Object[] options = new Object[]{LNG.get((String)"IAS_UPDATE"), LNG.get((String)"IAS_CANCEL")};
                if (options[selected = JOptionPane.showOptionDialog(PlatformInfoDialog.this.window, LNG.get((String)"IAS_PLATFORM_UPDATE_CONFIRMATION"), PlatformInfoDialog.this.windowLabel, -1, 1, null, options, options[0])] == LNG.get((String)"IAS_UPDATE") && PlatformInfoDialog.this.validateFields()) {
                    PlatformInfoDialog.this.modifyPlatform();
                }
                PlatformInfoDialog.this.window.close();
            }
        });
        return closeButton;
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        if (this.platform != null) {
            buttonPanel.add(this.makeChangeButton());
            buttonPanel.add(this.makeCloseButton());
        } else {
            buttonPanel.add(this.makeAddPlatformButton());
            buttonPanel.add(this.makeCancelButton());
        }
        return buttonPanel;
    }

    protected boolean validateFields() {
        String nameText = this.name.getText().trim();
        return !nameText.equals("");
    }

    private void createPlatform() {
        String nameText = this.name.getText().trim();
        String descriptionText = this.description.getText().trim();
        PlatformInfo platformInfo = new PlatformInfo(nameText, descriptionText);
        this.platform = PlatformProxy.createPlatform(this.window, this.windowLabel, LNG.get((String)"IAS_WAITING_PLATFORM_CREATION"), platformInfo);
        if (this.platform != null) {
            StandardDialogs.showInfoDialog((Component)this.window, (String)this.windowLabel, (Object)MessageFormat.format(LNG.get((String)"IAS_PLATFORM_INCLUDED_WITH_SUCCESS"), this.platform.getName()));
            this.platform = null;
            this.clearFields();
        }
    }

    private void modifyPlatform() {
        String nameText = this.name.getText().trim();
        String descText = this.description.getText().trim();
        PlatformInfo platformInfo = new PlatformInfo(nameText, descText);
        Platform modifiedPlatform = PlatformProxy.modifyPlatform(this.window, this.windowLabel, LNG.get((String)"IAS_WAITING_PLATFORM_MODIFICATION"), this.platform.getId(), platformInfo);
        if (modifiedPlatform != null) {
            this.platform = modifiedPlatform;
            StandardDialogs.showInfoDialog((Component)this.window, (String)this.windowLabel, (Object)MessageFormat.format(LNG.get((String)"IAS_PLATFORM_MODIFIED_WITH_SUCCESS"), this.platform.getName()));
            this.modifyPlatformButton.setEnabled(false);
        }
    }

    private void clearFields() {
        if (this.name == null || this.description == null) {
            return;
        }
        if (this.platform == null) {
            this.name.setText("");
            this.name.requestFocus();
        } else {
            this.description.requestFocus();
        }
        this.description.setText("");
    }

    public PlatformInfoDialog(Window owner) {
        this(owner, null);
    }

    public PlatformInfoDialog(Window owner, Platform platform) {
        this.owner = owner;
        if (platform == null) {
            this.windowLabel = LNG.get((String)"IAS_PLATFORM_INCLUSION_TITLE");
        } else {
            this.windowLabel = LNG.get((String)"IAS_PLATFORM_UPDATE_TITLE");
            this.platform = platform;
        }
        this.display();
    }

    private class ChangeListener
    extends KeyAdapter {
        private ChangeListener() {
        }

        @Override
        public void keyReleased(KeyEvent kev) {
            this.checkChange();
        }

        private void checkChange() {
            if (PlatformInfoDialog.this.name.getText().trim().equals(PlatformInfoDialog.this.platform.getName()) && PlatformInfoDialog.this.description.getText().trim().equals(PlatformInfoDialog.this.platform.getDescription())) {
                PlatformInfoDialog.this.modifyPlatformButton.setEnabled(false);
            } else {
                PlatformInfoDialog.this.modifyPlatformButton.setEnabled(true);
            }
        }
    }
}

